/*
 * Decompiled with CFR 0.152.
 */
package com.sosnitzka.taiga.traits;

import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.utils.ToolHelper;

public class TraitPulverizing
extends AbstractTrait {
    public TraitPulverizing() {
        super("pulverizing", TextFormatting.DARK_GRAY);
    }

    public void miningSpeed(ItemStack tool, PlayerEvent.BreakSpeed event) {
        if (ToolHelper.isToolEffective2((ItemStack)tool, (IBlockState)event.getState())) {
            event.setNewSpeed((float)((double)event.getNewSpeed() * this.calcBonus(tool)));
        }
    }

    private double calcBonus(ItemStack tool) {
        int durability = ToolHelper.getCurrentDurability((ItemStack)tool);
        int maxDurability = ToolHelper.getMaxDurability((ItemStack)tool);
        return 1.0f + 0.9f * (float)(maxDurability - durability) / (float)maxDurability;
    }

    public void blockHarvestDrops(ItemStack tool, BlockEvent.HarvestDropsEvent event) {
        if ((double)random.nextFloat() < 0.6) {
            event.getDrops().clear();
        }
    }
}

