/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.item;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.GameDictionary;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.data.Property;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.text.translation.Translatable;
import org.spongepowered.api.util.annotation.CatalogedBy;

@CatalogedBy(value={ItemTypes.class})
public interface ItemType
extends CatalogType,
Translatable,
GameDictionary.Entry {
    public Optional<BlockType> getBlock();

    public Optional<ItemType> getContainer();

    @Override
    public String getName();

    public int getMaxStackQuantity();

    public <T extends Property<?, ?>> Optional<T> getDefaultProperty(Class<T> var1);

    @Override
    default public ItemType getType() {
        return this;
    }

    @Override
    default public boolean matches(ItemStack stack) {
        return ((ItemStack)Preconditions.checkNotNull((Object)stack, (Object)"stack")).getType().equals(this);
    }

    @Override
    default public boolean isSpecific() {
        return false;
    }

    @Override
    default public ItemStackSnapshot getTemplate() {
        return ItemStack.of(this, 1).createSnapshot();
    }
}

