/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.entity;

import java.util.Optional;
import net.minecraft.entity.monster.EntityShulker;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.ImmutableDyeableData;
import org.spongepowered.api.data.manipulator.mutable.DyeableData;
import org.spongepowered.api.data.type.DyeColor;
import org.spongepowered.api.data.type.DyeColors;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.bridge.entity.monster.EntityShulkerBridge;
import org.spongepowered.common.data.manipulator.mutable.SpongeDyeableData;
import org.spongepowered.common.data.processor.common.AbstractEntitySingleDataProcessor;
import org.spongepowered.common.data.value.SpongeValueFactory;

public class ShulkerDyeColorDataProcessor
extends AbstractEntitySingleDataProcessor<EntityShulker, DyeColor, Value<DyeColor>, DyeableData, ImmutableDyeableData> {
    public ShulkerDyeColorDataProcessor() {
        super(EntityShulker.class, Keys.DYE_COLOR);
    }

    @Override
    protected Value<DyeColor> constructValue(DyeColor actualValue) {
        return SpongeValueFactory.getInstance().createValue(Keys.DYE_COLOR, actualValue, DyeColors.PURPLE);
    }

    @Override
    protected boolean set(EntityShulker container, DyeColor value) {
        ((EntityShulkerBridge)container).bridge$setColor(value);
        return true;
    }

    @Override
    protected Optional<DyeColor> getVal(EntityShulker container) {
        return Optional.of(((EntityShulkerBridge)container).bridge$getColor());
    }

    @Override
    protected ImmutableValue<DyeColor> constructImmutableValue(DyeColor value) {
        return this.constructValue(value).asImmutable();
    }

    @Override
    public boolean supports(EntityShulker dataHolder) {
        return dataHolder instanceof EntityShulkerBridge;
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }

    @Override
    protected DyeableData createManipulator() {
        return new SpongeDyeableData();
    }
}

