/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.tileentity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.tileentity.TileEntityArchetype;
import org.spongepowered.api.block.tileentity.TileEntityType;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.Queries;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.Location;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.block.SpongeTileEntityArchetypeBuilder;
import org.spongepowered.common.bridge.data.CustomDataHolderBridge;
import org.spongepowered.common.data.persistence.NbtTranslator;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.SpongeLocatableBlockBuilder;

@NonnullByDefault
@Mixin(value={TileEntity.class})
public abstract class TileEntityMixin_API
implements org.spongepowered.api.block.tileentity.TileEntity {
    @Shadow
    protected boolean field_145846_f;
    @Shadow
    protected World field_145850_b;
    @Shadow
    protected BlockPos field_174879_c;
    private final TileEntityType api$TileEntityType = SpongeImplHooks.getTileEntityType(((TileEntity)this).getClass());
    @Nullable
    private LocatableBlock api$LocatableBlock;

    @Shadow
    public abstract BlockPos func_174877_v();

    @Shadow
    public abstract Block func_145838_q();

    @Shadow
    public abstract NBTTagCompound func_189515_b(NBTTagCompound var1);

    @Shadow
    public abstract void shadow$func_70296_d();

    @Override
    public Location<org.spongepowered.api.world.World> getLocation() {
        return new Location<org.spongepowered.api.world.World>((org.spongepowered.api.world.World)this.field_145850_b, VecHelper.toVector3i(this.func_174877_v()));
    }

    @Override
    public int getContentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        DataContainer container = DataContainer.createNew().set(Queries.CONTENT_VERSION, (Object)this.getContentVersion()).set(Queries.WORLD_ID, (Object)((org.spongepowered.api.world.World)this.field_145850_b).getUniqueId().toString()).set(Queries.POSITION_X, (Object)this.func_174877_v().func_177958_n()).set(Queries.POSITION_Y, (Object)this.func_174877_v().func_177956_o()).set(Queries.POSITION_Z, (Object)this.func_174877_v().func_177952_p()).set(Constants.TileEntity.TILE_TYPE, (Object)this.api$TileEntityType.getId());
        NBTTagCompound compound = new NBTTagCompound();
        this.func_189515_b(compound);
        Constants.NBT.filterSpongeCustomData(compound);
        container.set(Constants.Sponge.UNSAFE_NBT, (Object)NbtTranslator.getInstance().translateFrom(compound));
        Collection<DataManipulator<?, ?>> manipulators = ((CustomDataHolderBridge)((Object)this)).bridge$getCustomManipulators();
        if (!manipulators.isEmpty()) {
            container.set(Constants.Sponge.DATA_MANIPULATORS, DataUtil.getSerializedManipulatorList(manipulators));
        }
        return container;
    }

    @Override
    public boolean validateRawData(DataView container) {
        return container.contains(Queries.WORLD_ID) && container.contains(Queries.POSITION_X) && container.contains(Queries.POSITION_Y) && container.contains(Queries.POSITION_Z) && container.contains(Constants.TileEntity.TILE_TYPE) && container.contains(Constants.Sponge.UNSAFE_NBT);
    }

    @Override
    public void setRawData(DataView container) throws InvalidDataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isValid() {
        return !this.field_145846_f;
    }

    @Override
    public void setValid(boolean valid) {
        this.field_145846_f = valid;
    }

    @Override
    public final TileEntityType getType() {
        return this.api$TileEntityType;
    }

    @Override
    public BlockState getBlock() {
        return (BlockState)this.field_145850_b.func_180495_p(this.func_174877_v());
    }

    public void supplyVanillaManipulators(List<DataManipulator<?, ?>> manipulators) {
    }

    @Override
    public Collection<DataManipulator<?, ?>> getContainers() {
        ArrayList list = Lists.newArrayList();
        this.supplyVanillaManipulators(list);
        if (this instanceof CustomDataHolderBridge) {
            list.addAll(((CustomDataHolderBridge)((Object)this)).bridge$getCustomManipulators());
        }
        return list;
    }

    @Override
    public TileEntityArchetype createArchetype() {
        return new SpongeTileEntityArchetypeBuilder().tile(this).build();
    }

    @Override
    public LocatableBlock getLocatableBlock() {
        if (this.api$LocatableBlock == null) {
            BlockState blockState = this.getBlock();
            this.api$LocatableBlock = new SpongeLocatableBlockBuilder().world((org.spongepowered.api.world.World)this.field_145850_b).position(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()).state(blockState).build();
        }
        return this.api$LocatableBlock;
    }
}

