/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.block;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableDirectionalData;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableHingeData;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableOpenData;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutablePortionData;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutablePoweredData;
import org.spongepowered.api.data.type.Hinge;
import org.spongepowered.api.data.type.PortionType;
import org.spongepowered.api.data.type.PortionTypes;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.util.Direction;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.data.ImmutableDataCachingUtil;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongeDirectionalData;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongeHingeData;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongeOpenData;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongePortionData;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongePoweredData;
import org.spongepowered.common.mixin.core.block.BlockMixin;
import org.spongepowered.common.util.Constants;

@Mixin(value={BlockDoor.class})
public abstract class BlockDoorMixin
extends BlockMixin {
    public ImmutableList<ImmutableDataManipulator<?, ?>> bridge$getManipulators(IBlockState blockState) {
        return ImmutableList.of((Object)this.impl$getHingeFor(blockState), (Object)this.impl$getIsOpenFor(blockState), (Object)this.impl$getIsPoweredFor(blockState), (Object)this.impl$getDirectionalData(blockState), (Object)this.impl$getPortionData(blockState));
    }

    @Override
    public boolean bridge$supports(Class<? extends ImmutableDataManipulator<?, ?>> immutable) {
        return ImmutableHingeData.class.isAssignableFrom(immutable) || ImmutableOpenData.class.isAssignableFrom(immutable) || ImmutablePoweredData.class.isAssignableFrom(immutable) || ImmutablePortionData.class.isAssignableFrom(immutable);
    }

    @Override
    public Optional<BlockState> bridge$getStateWithData(IBlockState blockState, ImmutableDataManipulator<?, ?> manipulator) {
        if (manipulator instanceof ImmutableHingeData) {
            BlockDoor.EnumHingePosition hinge = (BlockDoor.EnumHingePosition)((ImmutableHingeData)manipulator).type().get();
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)hinge));
        }
        if (manipulator instanceof ImmutableOpenData) {
            boolean isOpen = (Boolean)((ImmutableOpenData)manipulator).open().get();
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockDoor.field_176519_b, (Comparable)Boolean.valueOf(isOpen)));
        }
        if (manipulator instanceof ImmutablePoweredData) {
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockDoor.field_176522_N, (Comparable)((ImmutablePoweredData)manipulator).powered().get()));
        }
        if (manipulator instanceof ImmutableDirectionalData) {
            Direction dir = Constants.DirectionFunctions.checkDirectionToHorizontal((Direction)((Object)((ImmutableDirectionalData)manipulator).direction().get()));
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)Constants.DirectionFunctions.getFor(dir)));
        }
        if (manipulator instanceof ImmutablePortionData) {
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)this.impl$convertPortionType((PortionType)((ImmutablePortionData)manipulator).type().get())));
        }
        return super.bridge$getStateWithData(blockState, manipulator);
    }

    @Override
    public <E> Optional<BlockState> bridge$getStateWithValue(IBlockState blockState, Key<? extends BaseValue<E>> key, E value) {
        if (key.equals(Keys.HINGE_POSITION)) {
            BlockDoor.EnumHingePosition hinge = (BlockDoor.EnumHingePosition)value;
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)hinge));
        }
        if (key.equals(Keys.OPEN)) {
            boolean isOpen = (Boolean)value;
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockDoor.field_176519_b, (Comparable)Boolean.valueOf(isOpen)));
        }
        if (key.equals(Keys.POWERED)) {
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockDoor.field_176522_N, (Comparable)((Boolean)value)));
        }
        if (key.equals(Keys.DIRECTION)) {
            Direction dir = Constants.DirectionFunctions.checkDirectionToHorizontal((Direction)((Object)value));
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)Constants.DirectionFunctions.getFor(dir)));
        }
        if (key.equals(Keys.PORTION_TYPE)) {
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)this.impl$convertPortionType((PortionType)value)));
        }
        return super.bridge$getStateWithValue(blockState, key, value);
    }

    private BlockDoor.EnumDoorHalf impl$convertPortionType(PortionType portionType) {
        return portionType == PortionTypes.BOTTOM ? BlockDoor.EnumDoorHalf.LOWER : BlockDoor.EnumDoorHalf.UPPER;
    }

    private ImmutableHingeData impl$getHingeFor(IBlockState blockState) {
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeHingeData.class, (Hinge)((Object)blockState.func_177229_b((IProperty)BlockDoor.field_176521_M)));
    }

    private ImmutableOpenData impl$getIsOpenFor(IBlockState blockState) {
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeOpenData.class, blockState.func_177229_b((IProperty)BlockDoor.field_176519_b));
    }

    private ImmutablePoweredData impl$getIsPoweredFor(IBlockState blockState) {
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongePoweredData.class, blockState.func_177229_b((IProperty)BlockDoor.field_176522_N));
    }

    private ImmutableDirectionalData impl$getDirectionalData(IBlockState blockState) {
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeDirectionalData.class, new Object[]{Constants.DirectionFunctions.getFor((EnumFacing)blockState.func_177229_b((IProperty)BlockDoor.field_176520_a))});
    }

    private ImmutablePortionData impl$getPortionData(IBlockState blockState) {
        BlockDoor.EnumDoorHalf half = (BlockDoor.EnumDoorHalf)blockState.func_177229_b((IProperty)BlockDoor.field_176523_O);
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongePortionData.class, half == BlockDoor.EnumDoorHalf.LOWER ? PortionTypes.BOTTOM : PortionTypes.TOP);
    }
}

