/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.passive;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.village.MerchantRecipeList;
import org.spongepowered.api.data.type.Career;
import org.spongepowered.api.data.type.Profession;
import org.spongepowered.api.entity.living.Villager;
import org.spongepowered.api.item.merchant.TradeOffer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.bridge.entity.EntityVillagerBridge;
import org.spongepowered.common.bridge.item.inventory.InventoryAdapterBridge;
import org.spongepowered.common.entity.SpongeCareer;
import org.spongepowered.common.entity.SpongeEntityMeta;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.lens.Lens;
import org.spongepowered.common.item.inventory.lens.SlotProvider;
import org.spongepowered.common.item.inventory.lens.impl.collections.SlotCollection;
import org.spongepowered.common.item.inventory.lens.impl.minecraft.SingleOrderedLens;
import org.spongepowered.common.mixin.core.entity.EntityAgeableMixin;
import org.spongepowered.common.registry.SpongeVillagerRegistry;

@Mixin(value={EntityVillager.class})
public abstract class EntityVillagerMixin
extends EntityAgeableMixin
implements EntityVillagerBridge,
InventoryAdapter,
InventoryAdapterBridge {
    @Shadow
    private int field_175563_bv;
    @Shadow
    private int field_175562_bw;
    @Shadow
    @Nullable
    private MerchantRecipeList field_70963_i;
    @Shadow
    @Final
    private InventoryBasic field_175560_bz;
    @Nullable
    private Profession impl$profession;

    @Shadow
    public abstract void func_70938_b(int var1);

    @Shadow
    public abstract MerchantRecipeList func_70934_b(EntityPlayer var1);

    @Inject(method={"setProfession(I)V"}, at={@At(value="RETURN")})
    private void onSetProfession(int professionId, CallbackInfo ci) {
        this.impl$profession = SpongeImplHooks.validateProfession(professionId);
    }

    @Override
    public SlotProvider bridge$generateSlotProvider() {
        return new SlotCollection.Builder().add(8).build();
    }

    @Override
    public Lens bridge$generateLens(SlotProvider slots) {
        return new SingleOrderedLens(0, 8, InventoryBasic.class, slots);
    }

    @Override
    public Career bridge$getCareer() {
        List careers = (List)this.impl$profession.getCareers();
        if (this.field_175563_bv == 0 || this.field_175563_bv > careers.size()) {
            this.field_175563_bv = new Random().nextInt(careers.size()) + 1;
        }
        this.func_70934_b(null);
        return (Career)careers.get(this.field_175563_bv - 1);
    }

    @Override
    public Optional<Profession> bridge$getProfessionOptional() {
        return Optional.ofNullable(this.impl$profession);
    }

    @Override
    public void bridge$setProfession(Profession profession) {
        this.impl$profession = (Profession)Preconditions.checkNotNull((Object)profession, (Object)"VillagerProfession cannot be null!");
    }

    @Override
    public void bridge$setCareer(Career career) {
        this.func_70938_b(((SpongeEntityMeta)((Object)career.getProfession())).type);
        this.field_70963_i = null;
        this.field_175563_bv = ((SpongeCareer)career).type + 1;
        this.field_175562_bw = 1;
        this.func_70934_b(null);
    }

    @Overwrite
    private void func_175554_cu() {
        List careers = (List)this.impl$profession.getCareers();
        if (this.field_175563_bv != 0 && this.field_175562_bw != 0) {
            ++this.field_175562_bw;
        } else {
            this.field_175563_bv = this.field_70146_Z.nextInt(careers.size()) + 1;
            this.field_175562_bw = 1;
        }
        if (this.field_70963_i == null) {
            this.field_70963_i = new MerchantRecipeList();
        }
        Preconditions.checkState((this.field_175563_bv <= careers.size() ? 1 : 0) != 0, (Object)("The villager career id is out of bounds fo the available Careers! Found: " + this.field_175563_bv + " when the current maximum is: " + careers.size()));
        Career careerLevel = (Career)careers.get(this.field_175563_bv - 1);
        SpongeVillagerRegistry.getInstance().populateOffers((Villager)((Object)this), (List<TradeOffer>)this.field_70963_i, careerLevel, this.field_175562_bw, this.field_70146_Z);
    }
}

