/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.entitycollisions;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.bridge.world.WorldInfoBridge;
import org.spongepowered.common.config.SpongeConfig;
import org.spongepowered.common.config.category.CollisionModCategory;
import org.spongepowered.common.config.category.EntityCollisionCategory;
import org.spongepowered.common.config.type.GlobalConfig;
import org.spongepowered.common.config.type.WorldConfig;
import org.spongepowered.common.entity.SpongeEntityType;
import org.spongepowered.common.mixin.plugin.entitycollisions.interfaces.CollisionsCapability;

@Mixin(value={Entity.class}, priority=1002)
public class EntityMixin_Collisions
implements CollisionsCapability {
    @Shadow
    public World field_70170_p;
    private int collision$maxCollisions = 8;
    private boolean collision$refreshCache = false;
    private String collision$entityName = "unknown";
    private String collision$entityModId = "unknown";

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void collisions$InjectActivationInformation(World world, CallbackInfo ci) {
        if (world != null && !((WorldBridge)world).bridge$isFake() && ((WorldInfoBridge)world.func_72912_H()).bridge$isValid()) {
            EntityType entityType = ((org.spongepowered.api.entity.Entity)((Object)this)).getType();
            if (entityType == EntityTypes.UNKNOWN || !(entityType instanceof SpongeEntityType)) {
                return;
            }
            if ((Entity)this instanceof EntityItem) {
                EntityItem item = (EntityItem)this;
                ItemStack itemstack = item.func_92059_d();
                if (!itemstack.func_190926_b()) {
                    this.collision$entityName = itemstack.func_77977_a().replace("item.", "");
                }
            } else {
                this.collision$entityName = ((org.spongepowered.api.entity.Entity)((Object)this)).getType().getName();
            }
            this.collision$entityModId = ((SpongeEntityType)((org.spongepowered.api.entity.Entity)((Object)this)).getType()).getModId();
            if (!this.field_70170_p.field_72995_K) {
                this.collision$requiresCollisionsCacheRefresh(true);
            }
        }
    }

    @Override
    public int collision$getMaxCollisions() {
        return this.collision$maxCollisions;
    }

    @Override
    public void collision$setMaxCollisions(int max) {
        this.collision$maxCollisions = max;
    }

    @Override
    public void collision$setModDataName(String name) {
        this.collision$entityName = name;
    }

    @Override
    public String collision$getModDataName() {
        return this.collision$entityName;
    }

    @Override
    public String collision$getModDataId() {
        return this.collision$entityModId;
    }

    @Override
    public void collision$setModDataId(String id) {
        this.collision$entityModId = id;
    }

    @Override
    public void collision$initializeCollisionState(World world) {
        SpongeConfig<WorldConfig> worldConfigAdapter = ((WorldInfoBridge)world.func_72912_H()).bridge$getConfigAdapter();
        SpongeConfig<GlobalConfig> globalConfigAdapter = SpongeImpl.getGlobalConfigAdapter();
        EntityCollisionCategory worldCollCat = worldConfigAdapter.getConfig().getEntityCollisionCategory();
        EntityCollisionCategory globalCollCat = globalConfigAdapter.getConfig().getEntityCollisionCategory();
        this.collision$setMaxCollisions(worldCollCat.getMaxEntitiesWithinAABB());
        boolean requiresSave = false;
        CollisionModCategory worldCollMod = worldCollCat.getModList().get(this.collision$getModDataId());
        CollisionModCategory globalCollMod = globalCollCat.getModList().get(this.collision$getModDataId());
        if (worldCollMod == null && worldCollCat.autoPopulateData()) {
            globalCollMod = new CollisionModCategory(this.collision$getModDataId());
            globalCollCat.getModList().put(this.collision$getModDataId(), globalCollMod);
            globalCollMod.getEntityList().put(this.collision$getModDataName(), this.collision$getMaxCollisions());
            globalConfigAdapter.save();
            return;
        }
        if (worldCollMod != null) {
            if (!worldCollMod.isEnabled()) {
                this.collision$setMaxCollisions(-1);
                return;
            }
            Integer modCollisionMax = worldCollMod.getDefaultMaxCollisions().get("entities");
            if (modCollisionMax != null) {
                this.collision$setMaxCollisions(modCollisionMax);
            }
            Integer entityMaxCollision = null;
            if ((Entity)this instanceof EntityItem) {
                entityMaxCollision = worldCollMod.getEntityList().get(this.collision$getModDataName());
            }
            if (entityMaxCollision == null) {
                entityMaxCollision = worldCollMod.getEntityList().get(this.collision$getModDataName());
            }
            if (entityMaxCollision == null && worldCollCat.autoPopulateData()) {
                globalCollMod.getEntityList().put(this.collision$getModDataName(), this.collision$getMaxCollisions());
                requiresSave = true;
            } else if (entityMaxCollision != null) {
                this.collision$setMaxCollisions(entityMaxCollision);
            }
        }
        if (this.collision$getMaxCollisions() <= 0) {
            return;
        }
        if (requiresSave) {
            globalConfigAdapter.save();
        }
    }

    @Override
    public void collision$requiresCollisionsCacheRefresh(boolean flag) {
        this.collision$refreshCache = flag;
    }

    @Override
    public boolean collision$requiresCollisionsCacheRefresh() {
        return this.collision$refreshCache;
    }
}

