/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world;

import com.google.common.base.MoreObjects;
import org.spongepowered.api.world.ChunkRegenerateFlag;
import org.spongepowered.api.world.ChunkRegenerateFlags;
import org.spongepowered.common.registry.type.world.ChunkRegenerateFlagRegistryModule;

public final class SpongeChunkRegenerateFlag
implements ChunkRegenerateFlag {
    private final boolean create;
    private final boolean entities;
    private final int rawFlag;
    private final String name;

    public SpongeChunkRegenerateFlag(String name, int flag) {
        this.create = name.equals("all") || name.contains("create");
        this.entities = name.equals("all") || name.contains("entities");
        this.rawFlag = flag;
        this.name = name;
    }

    @Override
    public boolean create() {
        return this.create;
    }

    @Override
    public boolean entities() {
        return this.entities;
    }

    @Override
    public SpongeChunkRegenerateFlag withCreate(boolean create) {
        if (this.create == create) {
            return this;
        }
        return create ? this.andFlag(ChunkRegenerateFlags.CREATE) : this.andNotFlag(ChunkRegenerateFlags.CREATE);
    }

    @Override
    public SpongeChunkRegenerateFlag withEntities(boolean entities) {
        if (this.entities == entities) {
            return this;
        }
        return entities ? this.andFlag(ChunkRegenerateFlags.ENTITIES) : this.andNotFlag(ChunkRegenerateFlags.ENTITIES);
    }

    @Override
    public SpongeChunkRegenerateFlag andFlag(ChunkRegenerateFlag flag) {
        SpongeChunkRegenerateFlag o = (SpongeChunkRegenerateFlag)flag;
        int maskedFlag = (this.create || o.create ? 1 : 0) | (this.entities || o.entities ? 0 : 2);
        return ChunkRegenerateFlagRegistryModule.fromNativeInt(maskedFlag);
    }

    @Override
    public SpongeChunkRegenerateFlag andNotFlag(ChunkRegenerateFlag flag) {
        SpongeChunkRegenerateFlag o = (SpongeChunkRegenerateFlag)flag;
        int maskedFlag = (this.create && !o.create ? 1 : 0) | (this.entities && !o.entities ? 0 : 2);
        return ChunkRegenerateFlagRegistryModule.fromNativeInt(maskedFlag);
    }

    public String getName() {
        return this.name;
    }

    public int getRawFlag() {
        return this.rawFlag;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("rawFlag", this.rawFlag).add("create", this.create).add("entities", this.entities).toString();
    }
}

