/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.mixin.core.block;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.block.BlockPhase;
import org.spongepowered.common.mixin.core.block.BlockMixin;
import org.spongepowered.common.world.SpongeLocatableBlockBuilder;

@NonnullByDefault
@Mixin(value={BlockLog.class}, priority=1001)
public abstract class BlockLogMixin_Forge
extends BlockMixin {
    @Redirect(method={"breakBlock"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/Block;beginLeavesDecay(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)V", remap=false))
    private void onSpongeBreakBlock(Block block, IBlockState state, World worldIn, BlockPos pos) {
        if (((WorldBridge)worldIn).bridge$isFake() || !ShouldFire.CHANGE_BLOCK_EVENT_PRE) {
            block.beginLeavesDecay(state, worldIn, pos);
            return;
        }
        if (SpongeCommonEventFactory.callChangeBlockEventPre((WorldServerBridge)worldIn, pos).isCancelled()) {
            return;
        }
        PhaseTracker phaseTracker = PhaseTracker.getInstance();
        IPhaseState<?> currentState = phaseTracker.getCurrentState();
        try (PhaseContext<?> decayContext = this.createDecayContext((BlockState)state, (org.spongepowered.api.world.World)worldIn, pos, !currentState.includesDecays());){
            if (decayContext != null) {
                decayContext.buildAndSwitch();
            }
            block.beginLeavesDecay(state, worldIn, pos);
        }
    }

    @Nullable
    private PhaseContext<?> createDecayContext(BlockState state, org.spongepowered.api.world.World worldIn, BlockPos pos, boolean canCreate) {
        if (canCreate) {
            LocatableBlock locatable = new SpongeLocatableBlockBuilder().world(worldIn).position(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()).state(state).build();
            return ((PhaseContext)BlockPhase.State.BLOCK_DECAY.createPhaseContext()).source(locatable);
        }
        return null;
    }
}

