/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.opengl.GL11;
import vazkii.botania.api.lexicon.ILexicon;
import vazkii.botania.api.lexicon.LexiconRecipeMappings;
import vazkii.botania.api.mana.IManaTooltipDisplay;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.item.ItemLexicon;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.tool.terrasteel.ItemTerraPick;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="botania")
public final class TooltipAdditionDisplayHandler {
    private static float lexiconLookupTime = 0.0f;

    @SubscribeEvent
    public static void onToolTipRender(RenderTooltipEvent.PostText evt) {
        if (evt.getStack().func_190926_b()) {
            return;
        }
        ItemStack stack = evt.getStack();
        Minecraft mc = Minecraft.func_71410_x();
        int width = evt.getWidth();
        int height = 3;
        int tooltipX = evt.getX();
        int tooltipY = evt.getY() - 4;
        FontRenderer font = evt.getFontRenderer();
        if (stack.func_77973_b() instanceof ItemTerraPick) {
            TooltipAdditionDisplayHandler.drawTerraPick(stack, tooltipX, tooltipY, width, height, font);
        } else if (stack.func_77973_b() instanceof IManaTooltipDisplay) {
            TooltipAdditionDisplayHandler.drawManaBar(stack, (IManaTooltipDisplay)stack.func_77973_b(), tooltipX, tooltipY, width, height);
        }
        LexiconRecipeMappings.EntryData data = LexiconRecipeMappings.getDataForStack(stack);
        if (mc.field_71439_g != null && data != null) {
            int lexSlot = -1;
            ItemStack lexiconStack = ItemStack.field_190927_a;
            for (int i = 0; i < InventoryPlayer.func_70451_h(); ++i) {
                ItemStack stackAt = mc.field_71439_g.field_71071_by.func_70301_a(i);
                if (stackAt.func_190926_b() || !(stackAt.func_77973_b() instanceof ILexicon) || !((ILexicon)stackAt.func_77973_b()).isKnowledgeUnlocked(stackAt, data.entry.getKnowledgeType())) continue;
                lexiconStack = stackAt;
                lexSlot = i;
                break;
            }
            if (lexSlot > -1) {
                int x = tooltipX - 34;
                GlStateManager.func_179097_i();
                Gui.func_73734_a((int)(x - 4), (int)(tooltipY - 4), (int)(x + 20), (int)(tooltipY + 26), (int)0x44000000);
                Gui.func_73734_a((int)(x - 6), (int)(tooltipY - 6), (int)(x + 22), (int)(tooltipY + 28), (int)0x44000000);
                if (ConfigHandler.useShiftForQuickLookup ? GuiScreen.func_146272_n() : GuiScreen.func_146271_m()) {
                    int cx = x + 8;
                    int cy = tooltipY + 8;
                    float r = 12.0f;
                    float time = 20.0f;
                    float angles = (lexiconLookupTime += ClientTickHandler.delta) / time * 360.0f;
                    GlStateManager.func_179140_f();
                    GlStateManager.func_179090_x();
                    GlStateManager.func_179103_j((int)7425);
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179112_b((int)770, (int)771);
                    BufferBuilder buf = Tessellator.func_178181_a().func_178180_c();
                    buf.func_181668_a(6, DefaultVertexFormats.field_181706_f);
                    float a = 0.5f + 0.2f * ((float)Math.cos((double)((float)ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks) / 10.0) * 0.5f + 0.5f);
                    buf.func_181662_b((double)cx, (double)cy, 0.0).func_181666_a(0.0f, 0.5f, 0.0f, a).func_181675_d();
                    for (float i = angles; i > 0.0f; i -= 1.0f) {
                        double rad = (double)((i - 90.0f) / 180.0f) * Math.PI;
                        buf.func_181662_b((double)cx + Math.cos(rad) * (double)r, (double)cy + Math.sin(rad) * (double)r, 0.0).func_181666_a(0.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
                    }
                    buf.func_181662_b((double)cx, (double)cy, 0.0).func_181666_a(0.0f, 1.0f, 0.0f, 0.0f).func_181675_d();
                    Tessellator.func_178181_a().func_78381_a();
                    GlStateManager.func_179084_k();
                    GlStateManager.func_179098_w();
                    GlStateManager.func_179103_j((int)7424);
                    if (lexiconLookupTime >= time) {
                        mc.field_71439_g.field_71071_by.field_70461_c = lexSlot;
                        Botania.proxy.setEntryToOpen(data.entry);
                        Botania.proxy.setLexiconStack(lexiconStack);
                        mc.field_71439_g.func_71053_j();
                        ItemLexicon.openBook((EntityPlayer)mc.field_71439_g, lexiconStack, (World)mc.field_71441_e, false);
                    }
                } else {
                    lexiconLookupTime = 0.0f;
                }
                mc.func_175599_af().func_175042_a(new ItemStack(ModItems.lexicon), x, tooltipY);
                GlStateManager.func_179140_f();
                font.func_175063_a("?", (float)(x + 10), (float)(tooltipY + 8), -1);
                GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)1.0f);
                boolean mac = Minecraft.field_142025_a;
                mc.field_71466_p.func_175063_a(TextFormatting.BOLD + (ConfigHandler.useShiftForQuickLookup ? "Shift" : (mac ? "Cmd" : "Ctrl")), (float)((x + 10) * 2 - 16), (float)((tooltipY + 8) * 2 + 20), -1);
                GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)1.0f);
                GlStateManager.func_179126_j();
            } else {
                lexiconLookupTime = 0.0f;
            }
        } else {
            lexiconLookupTime = 0.0f;
        }
    }

    private static void drawTerraPick(ItemStack stack, int mouseX, int mouseY, int width, int height, FontRenderer font) {
        int level = ItemTerraPick.getLevel(stack);
        int max = ItemTerraPick.LEVELS[Math.min(ItemTerraPick.LEVELS.length - 1, level + 1)];
        boolean ss = level >= ItemTerraPick.LEVELS.length - 1;
        int curr = ItemTerraPick.getMana_(stack);
        float percent = level == 0 ? 0.0f : (float)curr / (float)max;
        int rainbowWidth = Math.min(width - (ss ? 0 : 1), (int)((float)width * percent));
        float huePer = width == 0 ? 0.0f : 1.0f / (float)width;
        float hueOff = ((float)ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks) * 0.01f;
        GlStateManager.func_179097_i();
        Gui.func_73734_a((int)(mouseX - 1), (int)(mouseY - height - 1), (int)(mouseX + width + 1), (int)mouseY, (int)-16777216);
        for (int i = 0; i < rainbowWidth; ++i) {
            Gui.func_73734_a((int)(mouseX + i), (int)(mouseY - height), (int)(mouseX + i + 1), (int)mouseY, (int)Color.HSBtoRGB(hueOff + huePer * (float)i, 1.0f, 1.0f));
        }
        Gui.func_73734_a((int)(mouseX + rainbowWidth), (int)(mouseY - height), (int)(mouseX + width), (int)mouseY, (int)-11184811);
        String rank = I18n.func_135052_a((String)("botania.rank" + level), (Object[])new Object[0]).replaceAll("&", "\u00a7");
        GL11.glPushAttrib((int)64);
        GlStateManager.func_179140_f();
        font.func_175063_a(rank, (float)mouseX, (float)(mouseY - 12), 0xFFFFFF);
        if (!ss) {
            rank = I18n.func_135052_a((String)("botania.rank" + (level + 1)), (Object[])new Object[0]).replaceAll("&", "\u00a7");
            font.func_175063_a(rank, (float)(mouseX + width - font.func_78256_a(rank)), (float)(mouseY - 12), 0xFFFFFF);
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        GL11.glPopAttrib();
    }

    private static void drawManaBar(ItemStack stack, IManaTooltipDisplay display, int mouseX, int mouseY, int width, int height) {
        float fraction = display.getManaFractionForDisplay(stack);
        int manaBarWidth = (int)Math.ceil((float)width * fraction);
        GlStateManager.func_179097_i();
        Gui.func_73734_a((int)(mouseX - 1), (int)(mouseY - height - 1), (int)(mouseX + width + 1), (int)mouseY, (int)-16777216);
        Gui.func_73734_a((int)mouseX, (int)(mouseY - height), (int)(mouseX + manaBarWidth), (int)mouseY, (int)Color.HSBtoRGB(0.528f, ((float)Math.sin((double)((float)ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks) * 0.2) + 1.0f) * 0.3f + 0.4f, 1.0f));
        Gui.func_73734_a((int)(mouseX + manaBarWidth), (int)(mouseY - height), (int)(mouseX + width), (int)mouseY, (int)-11184811);
    }
}

