/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.handler.chunkanalyzer;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ChunkAnalyzerResult {
    public List<ItemStack> displayStacks = new ArrayList<ItemStack>();
    public List<String> blockDescriptions = new ArrayList<String>();
    public List<Integer> blockCounts = new ArrayList<Integer>();

    public void addBlock(ItemStack displayStack, String blockDescription, int count) {
        this.displayStacks.add(displayStack);
        this.blockDescriptions.add(blockDescription);
        this.blockCounts.add(count);
    }

    public void writeToNBT(NBTTagCompound compound) {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.displayStacks.size(); ++i) {
            ItemStack stack = this.displayStacks.get(i);
            NBTTagCompound entryCompound = new NBTTagCompound();
            NBTTagCompound stackCompound = new NBTTagCompound();
            stack.func_77955_b(stackCompound);
            entryCompound.func_74782_a("stack", (NBTBase)stackCompound);
            entryCompound.func_74778_a("description", this.blockDescriptions.get(i));
            entryCompound.func_74768_a("count", this.blockCounts.get(i).intValue());
            tagList.func_74742_a((NBTBase)entryCompound);
        }
        compound.func_74782_a("entries", (NBTBase)tagList);
    }

    public void readFromNBT(NBTTagCompound compound) {
        NBTTagList entryList = compound.func_150295_c("entries", 10);
        for (int i = 0; i < entryList.func_74745_c(); ++i) {
            NBTTagCompound entryCompound = entryList.func_150305_b(i);
            ItemStack stack = new ItemStack(entryCompound.func_74775_l("stack"));
            String description = entryCompound.func_74779_i("description");
            int count = entryCompound.func_74762_e("count");
            this.displayStacks.add(stack);
            this.blockDescriptions.add(description);
            this.blockCounts.add(count);
        }
    }
}

