/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.handler.festival;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.INBTSerializable;

public class Festival
implements INBTSerializable<NBTTagCompound> {
    int dimensionID;
    List<BlockPos> doorPositions = new ArrayList<BlockPos>();
    STATE state = STATE.SCHEDULED;

    public void addDoorPos(BlockPos pos) {
        this.doorPositions.add(pos);
    }

    public List<BlockPos> getDoorPositions() {
        return this.doorPositions;
    }

    public STATE getState() {
        return this.state;
    }

    public void setActive() {
        this.state = STATE.ACTIVE;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList nbtList = new NBTTagList();
        for (BlockPos p : this.doorPositions) {
            NBTTagCompound posCompound = new NBTTagCompound();
            posCompound.func_74768_a("posX", p.func_177958_n());
            posCompound.func_74768_a("posY", p.func_177956_o());
            posCompound.func_74768_a("posZ", p.func_177952_p());
            nbtList.func_74742_a((NBTBase)posCompound);
        }
        compound.func_74782_a("doorPositions", (NBTBase)nbtList);
        compound.func_74768_a("state", this.state.ordinal());
        return compound;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        NBTTagList tagList = nbt.func_150295_c("doorPositions", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound comp = tagList.func_150305_b(i);
            BlockPos pos = new BlockPos(comp.func_74762_e("posX"), comp.func_74762_e("posY"), comp.func_74762_e("posZ"));
            this.doorPositions.add(pos);
        }
        this.state = STATE.values()[nbt.func_74762_e("state")];
    }

    static enum STATE {
        SCHEDULED,
        ACTIVE;

    }
}

