/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.configurate.reference;

import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import me.lucko.luckperms.lib.configurate.reactive.Disposable;
import me.lucko.luckperms.lib.configurate.reactive.Processor;
import me.lucko.luckperms.lib.configurate.reactive.Subscriber;
import org.checkerframework.checker.nullness.qual.Nullable;

class DirectoryListenerRegistration
implements Subscriber<WatchEvent<?>> {
    private final Lock lock = new ReentrantLock();
    private final WatchKey key;
    private final ConcurrentHashMap<Path, Processor<WatchEvent<?>, WatchEvent<?>>> fileListeners = new ConcurrentHashMap();
    private final Executor executor;
    private final Processor<WatchEvent<?>, WatchEvent<?>> dirListeners;

    DirectoryListenerRegistration(WatchKey key, Executor executor) {
        this.key = Objects.requireNonNull(key, "key");
        this.executor = Objects.requireNonNull(executor, "executor");
        this.dirListeners = Processor.create(executor);
    }

    public WatchKey getKey() {
        return this.key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submit(WatchEvent<?> item) {
        Path file = (Path)item.context();
        this.lock.lock();
        try {
            @Nullable Processor fileListeners = this.fileListeners.computeIfPresent(file, (key, old) -> old.closeIfUnsubscribed() ? null : old);
            this.dirListeners.submit(item);
            if (fileListeners != null) {
                fileListeners.submit(item);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void onClose() {
        this.lock.lock();
        try {
            try {
                this.dirListeners.onClose();
            }
            catch (Throwable t) {
                this.dirListeners.onError(t);
            }
            this.fileListeners.forEach((k, v) -> {
                try {
                    v.onClose();
                }
                catch (Throwable t) {
                    v.onError(t);
                }
            });
            this.fileListeners.clear();
            this.key.cancel();
        }
        finally {
            this.lock.unlock();
        }
    }

    public Disposable subscribe(Subscriber<WatchEvent<?>> subscriber) {
        this.lock.lock();
        try {
            Disposable disposable = this.dirListeners.subscribe(subscriber);
            return disposable;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Disposable subscribe(Path file, Subscriber<WatchEvent<?>> subscriber) {
        this.lock.lock();
        try {
            Disposable disposable = this.fileListeners.computeIfAbsent(file, f -> Processor.create(this.executor)).subscribe(subscriber);
            return disposable;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean hasSubscribers() {
        this.lock.lock();
        try {
            boolean bl = this.dirListeners.hasSubscribers() || !this.fileListeners.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DirectoryListenerRegistration)) {
            return false;
        }
        DirectoryListenerRegistration that = (DirectoryListenerRegistration)o;
        return this.getKey().equals(that.getKey()) && this.fileListeners.equals(that.fileListeners) && this.dirListeners.equals(that.dirListeners);
    }

    public int hashCode() {
        return Objects.hash(this.getKey(), this.fileListeners, this.dirListeners);
    }

    public boolean closeIfEmpty() {
        this.lock.lock();
        try {
            if (!this.hasSubscribers()) {
                this.onClose();
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lock.unlock();
        }
        return false;
    }
}

