/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.configurate.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class EnumLookup {
    private static final LoadingCache<Class<? extends Enum<?>>, Map<String, Enum<?>>> ENUM_FIELD_CACHE = CacheBuilder.newBuilder().weakKeys().maximumSize(512L).build(new CacheLoader<Class<? extends Enum<?>>, Map<String, Enum<?>>>(){

        public Map<String, Enum<?>> load(@NonNull Class<? extends Enum<?>> key) {
            HashMap ret = new HashMap();
            for (Enum<?> field : key.getEnumConstants()) {
                ret.put(field.name(), field);
                ret.putIfAbsent(EnumLookup.processKey(field.name()), field);
            }
            return ImmutableMap.copyOf(ret);
        }
    });

    private EnumLookup() {
    }

    private static @NonNull String processKey(@NonNull String key) {
        return "\ud83c\udf38" + key.toLowerCase().replace("_", "");
    }

    public static <T extends Enum<T>> @NonNull Optional<T> lookupEnum(@NonNull Class<T> clazz, @NonNull String key) {
        try {
            Map vals = (Map)ENUM_FIELD_CACHE.get(Objects.requireNonNull(clazz, "clazz"));
            Enum possibleRet = (Enum)vals.get(Objects.requireNonNull(key, "key"));
            if (possibleRet != null) {
                return Optional.of(possibleRet);
            }
            return Optional.ofNullable((Enum)vals.get(EnumLookup.processKey(key)));
        }
        catch (ExecutionException e) {
            return Optional.empty();
        }
    }
}

