/*
 * Decompiled with CFR 0.152.
 */
package com.erigitic.jobs;

import com.erigitic.jobs.TEAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import ninja.leaping.configurate.ConfigurationNode;

public class TEJobSet {
    private List<TEAction> actions = new ArrayList<TEAction>();

    public TEJobSet(ConfigurationNode node) {
        node.getChildrenMap().forEach((actionStr, targetNode) -> {
            if (actionStr instanceof String && targetNode != null) {
                targetNode.getChildrenMap().forEach((targetID, actionNode) -> {
                    if (targetID instanceof String && actionNode != null) {
                        TEAction action = new TEAction();
                        action.loadConfigNode((String)actionStr, (ConfigurationNode)actionNode);
                        if (action.isValid()) {
                            this.actions.add(action);
                        }
                    }
                });
            }
        });
    }

    public Optional<TEAction> getActionFor(String action, String targetID) {
        return this.actions.stream().filter(teAction -> teAction.getAction().equals(action)).filter(teAction -> teAction.getTargetId().equals(targetID)).findFirst();
    }

    public List<TEAction> getActions() {
        return this.actions;
    }
}

