/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.block;

import WayofTime.bloodmagic.BloodMagic;
import WayofTime.bloodmagic.block.IBMBlock;
import WayofTime.bloodmagic.client.IVariantProvider;
import WayofTime.bloodmagic.item.ItemDemonCrystal;
import WayofTime.bloodmagic.item.block.ItemBlockDemonCrystal;
import WayofTime.bloodmagic.soul.EnumDemonWillType;
import WayofTime.bloodmagic.soul.PlayerDemonWillHandler;
import WayofTime.bloodmagic.tile.TileDemonCrystal;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockDemonCrystal
extends Block
implements IBMBlock,
IVariantProvider {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)6);
    public static final PropertyEnum<EnumDemonWillType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumDemonWillType.class);
    public static final PropertyEnum<EnumFacing> ATTACHED = PropertyEnum.func_177709_a((String)"attached", EnumFacing.class);
    private static final EnumMap<EnumFacing, AxisAlignedBB> bounds = new EnumMap(EnumFacing.class);
    private static final AxisAlignedBB[] UP = new AxisAlignedBB[]{new AxisAlignedBB(0.375, 0.0, 0.3125, 0.625, 0.8125, 0.5625), new AxisAlignedBB(0.4375, 0.0, 0.0, 0.8125, 0.375, 0.3125), new AxisAlignedBB(0.5625, 0.0, 0.5625, 0.8125, 0.3125, 0.875), new AxisAlignedBB(0.125, 0.0, 0.0625, 0.4375, 0.375, 0.4375), new AxisAlignedBB(0.3125, 0.0, 0.5625, 0.5625, 0.4375, 0.9375), new AxisAlignedBB(0.0, 0.0, 0.4375, 0.375, 0.375, 0.625), new AxisAlignedBB(0.625, 0.0, 0.375, 0.9375, 0.375, 0.5625)};
    private static final AxisAlignedBB[] DOWN = new AxisAlignedBB[]{new AxisAlignedBB(0.375, 0.1875, 0.4375, 0.625, 1.0, 0.6875), new AxisAlignedBB(0.4375, 0.625, 0.6875, 0.8125, 1.0, 1.0), new AxisAlignedBB(0.5625, 0.6875, 0.125, 0.8125, 1.0, 0.4375), new AxisAlignedBB(0.125, 0.5625, 0.6875, 0.4375, 1.0, 0.9375), new AxisAlignedBB(0.3125, 0.5625, 0.0625, 0.5625, 1.0, 0.4375), new AxisAlignedBB(0.0, 0.625, 0.375, 0.375, 1.0, 0.5625), new AxisAlignedBB(0.625, 0.6875, 0.4375, 0.9375, 1.0, 0.625)};
    private static final AxisAlignedBB[] NORTH = new AxisAlignedBB[]{new AxisAlignedBB(0.375, 0.3125, 0.1875, 0.625, 0.5625, 1.0), new AxisAlignedBB(0.5625, 0.0, 0.375, 0.8125, 0.3125, 1.0), new AxisAlignedBB(0.5, 0.5625, 0.6875, 0.8125, 0.875, 1.0), new AxisAlignedBB(0.125, 0.0625, 0.5625, 0.4375, 0.4375, 1.0), new AxisAlignedBB(0.3125, 0.5625, 0.5625, 0.5625, 0.9375, 1.0), new AxisAlignedBB(0.0, 0.4375, 0.625, 0.375, 0.625, 1.0), new AxisAlignedBB(0.625, 0.4375, 0.625, 0.9375, 0.5625, 0.9375)};
    private static final AxisAlignedBB[] SOUTH = new AxisAlignedBB[]{new AxisAlignedBB(0.375, 0.4375, 0.0, 0.625, 0.6875, 0.8125), new AxisAlignedBB(0.4375, 0.6875, 0.0, 0.8125, 1.0, 0.375), new AxisAlignedBB(0.5, 0.125, 0.5625, 0.8125, 0.4375, 0.875), new AxisAlignedBB(0.125, 0.5625, 0.0625, 0.4375, 0.875, 0.4375), new AxisAlignedBB(0.3125, 0.0625, 0.5625, 0.5625, 0.4375, 0.5625), new AxisAlignedBB(0.0, 0.375, 0.0625, 0.375, 0.5625, 0.4375), new AxisAlignedBB(0.625, 0.5, 0.0625, 0.9375, 0.625, 0.375)};
    private static final AxisAlignedBB[] EAST = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.375, 0.3125, 0.8125, 0.625, 0.5625), new AxisAlignedBB(0.0, 0.1875, 0.0, 0.375, 0.5625, 0.3125), new AxisAlignedBB(0.0, 0.1875, 0.5625, 0.3125, 0.5, 0.875), new AxisAlignedBB(0.0625, 0.5625, 0.0625, 0.4375, 0.8125, 0.4375), new AxisAlignedBB(0.0625, 0.0, 0.5625, 0.4375, 0.6875, 0.9375), new AxisAlignedBB(0.0, 0.625, 0.4375, 0.375, 1.0, 0.625), new AxisAlignedBB(0.0, 0.0625, 0.375, 0.3125, 0.375, 0.5625)};
    private static final AxisAlignedBB[] WEST = new AxisAlignedBB[]{new AxisAlignedBB(0.1875, 0.375, 0.3125, 1.0, 0.625, 0.5625), new AxisAlignedBB(0.5625, 0.4375, 0.0, 1.0, 0.75, 0.3125), new AxisAlignedBB(0.6875, 0.25, 0.5625, 1.0, 0.8125, 0.875), new AxisAlignedBB(0.5625, 0.1875, 0.0625, 1.0, 0.5, 0.4375), new AxisAlignedBB(0.5625, 0.375, 0.5625, 1.0, 0.5, 0.9375), new AxisAlignedBB(0.625, 0.0625, 0.4375, 1.0, 0.375, 0.625), new AxisAlignedBB(0.625, 0.375, 0.375, 0.9375, 0.9375, 0.5625)};

    public BlockDemonCrystal() {
        super(Material.field_151576_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, (Comparable)((Object)EnumDemonWillType.DEFAULT)).func_177226_a(ATTACHED, (Comparable)EnumFacing.UP));
        this.func_149663_c("bloodmagic.demonCrystal.");
        this.func_149647_a(BloodMagic.TAB_BM);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.setHarvestLevel("pickaxe", 2);
    }

    public static ItemStack getItemStackDropped(EnumDemonWillType type, int crystalNumber) {
        ItemStack stack = ItemStack.field_190927_a;
        switch (type) {
            case CORROSIVE: {
                stack = EnumDemonWillType.CORROSIVE.getStack();
                break;
            }
            case DEFAULT: {
                stack = EnumDemonWillType.DEFAULT.getStack();
                break;
            }
            case DESTRUCTIVE: {
                stack = EnumDemonWillType.DESTRUCTIVE.getStack();
                break;
            }
            case STEADFAST: {
                stack = EnumDemonWillType.STEADFAST.getStack();
                break;
            }
            case VENGEFUL: {
                stack = EnumDemonWillType.VENGEFUL.getStack();
            }
        }
        stack.func_190920_e(crystalNumber);
        return stack;
    }

    private static List<AxisAlignedBB> getCollisionBoxList(IBlockState state) {
        int age = (Integer)state.func_177229_b((IProperty)AGE) + 1;
        switch ((EnumFacing)state.func_177229_b(ATTACHED)) {
            case DOWN: {
                return Arrays.asList(DOWN).subList(0, age);
            }
            case NORTH: {
                return Arrays.asList(NORTH).subList(0, age);
            }
            case SOUTH: {
                return Arrays.asList(SOUTH).subList(0, age);
            }
            case WEST: {
                return Arrays.asList(WEST).subList(0, age);
            }
            case EAST: {
                return Arrays.asList(EAST).subList(0, age);
            }
        }
        return Arrays.asList(UP).subList(0, age);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        TileEntity tile = source.func_175625_s(pos);
        if (tile != null) {
            state = this.func_176221_a(state, (IBlockAccess)tile.func_145831_w(), pos);
        }
        switch ((EnumFacing)state.func_177229_b(ATTACHED)) {
            case DOWN: {
                return DOWN[0];
            }
            case NORTH: {
                return NORTH[0];
            }
            case SOUTH: {
                return SOUTH[0];
            }
            case EAST: {
                return EAST[0];
            }
            case WEST: {
                return WEST[0];
            }
        }
        return UP[0];
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        if (!world.field_72995_K && (tile = world.func_175625_s(pos)) instanceof TileDemonCrystal) {
            TileDemonCrystal crystal = (TileDemonCrystal)tile;
            boolean isCreative = player.field_71075_bZ.field_75098_d;
            boolean holdsCrystal = player.func_184586_b(hand).func_77973_b() instanceof ItemDemonCrystal;
            if (!(!(PlayerDemonWillHandler.getTotalDemonWill(EnumDemonWillType.DEFAULT, player) > 1024.0) || holdsCrystal && isCreative)) {
                crystal.dropSingleCrystal();
            }
            if (!crystal.func_145831_w().field_72995_K && isCreative && holdsCrystal && crystal.crystalCount < 7) {
                crystal.internalCounter = 0;
                if (crystal.progressToNextCrystal > 0.0) {
                    crystal.progressToNextCrystal -= 1.0;
                }
                ++crystal.crystalCount;
                crystal.func_70296_d();
                crystal.notifyUpdate();
            }
        }
        return true;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileDemonCrystal) {
            EnumDemonWillType type = (EnumDemonWillType)((Object)state.func_177229_b(TYPE));
            int number = ((TileDemonCrystal)tile).getCrystalCount();
            drops.add((Object)BlockDemonCrystal.getItemStackDropped(type, number));
        }
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileDemonCrystal) {
            TileDemonCrystal crystal = (TileDemonCrystal)tile;
            state = state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(crystal.getCrystalCountForRender()));
            state = state.func_177226_a(ATTACHED, (Comparable)crystal.getPlacement());
        }
        return state;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileDemonCrystal crystal;
        EnumFacing placement;
        BlockPos offsetPos;
        IBlockState offsetState;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileDemonCrystal && !(offsetState = world.func_180495_p(offsetPos = pos.func_177972_a((placement = (crystal = (TileDemonCrystal)tile).getPlacement()).func_176734_d()))).isSideSolid((IBlockAccess)world, offsetPos, placement)) {
            world.func_175655_b(pos, true);
        }
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        BlockPos offsetPos = pos.func_177972_a(side.func_176734_d());
        IBlockState offsetState = world.func_180495_p(offsetPos);
        return offsetState.isSideSolid((IBlockAccess)world, offsetPos, side) && this.func_176196_c(world, pos);
    }

    public void func_149666_a(CreativeTabs creativeTabs, NonNullList<ItemStack> list) {
        for (EnumDemonWillType willType : EnumDemonWillType.values()) {
            list.add((Object)new ItemStack((Block)this, 1, willType.ordinal()));
        }
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity tile, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, tile, stack);
        world.func_175698_g(pos);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumDemonWillType.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumDemonWillType)((Object)state.func_177229_b(TYPE))).ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE, AGE, ATTACHED});
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileDemonCrystal();
    }

    @Override
    public ItemBlock getItem() {
        return new ItemBlockDemonCrystal(this);
    }

    @Override
    public void gatherVariants(@Nonnull Int2ObjectMap<String> variants) {
        for (EnumDemonWillType willType : EnumDemonWillType.values()) {
            variants.put(willType.ordinal(), (Object)("age=3,attached=up,type=" + willType.func_176610_l()));
        }
    }

    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        ArrayList list = Lists.newArrayList();
        for (AxisAlignedBB axisalignedbb : BlockDemonCrystal.getCollisionBoxList(this.func_176221_a(blockState, (IBlockAccess)worldIn, pos))) {
            list.add(this.func_185503_a(pos, start, end, axisalignedbb));
        }
        RayTraceResult rayTrace = null;
        double d1 = 0.0;
        for (RayTraceResult raytraceresult : list) {
            double d0;
            if (raytraceresult == null || !((d0 = raytraceresult.field_72307_f.func_72436_e(end)) > d1)) continue;
            rayTrace = raytraceresult;
            d1 = d0;
        }
        return rayTrace;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean bool) {
        state = this.func_176221_a(state, (IBlockAccess)worldIn, pos);
        for (AxisAlignedBB axisalignedbb : BlockDemonCrystal.getCollisionBoxList(state)) {
            BlockDemonCrystal.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)axisalignedbb);
        }
    }
}

