/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.fixers;

import javax.annotation.Nonnull;
import mekanism.common.util.LangUtils;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KeybindingFixer {
    private static final Logger LOGGER = LogManager.getLogger((String)"Mekanism KeybindingFixer");

    public static void runFix(NBTTagCompound compound) {
        KeybindingFixer.remapKey(compound, "key_Mekanism Item Mode Switch", "mekanism.key.mode");
        KeybindingFixer.remapKey(compound, "key_Mekanism Armor Mode Switch", "mekanism.key.armorMode");
        KeybindingFixer.remapKey(compound, "key_Mekanism Feet Mode Switch", "mekanism.key.feetMode");
        KeybindingFixer.remapKey(compound, "key_Mekanism Voice", "mekanism.key.voice");
    }

    private static void remapKey(@Nonnull NBTTagCompound compound, String oldKey, String langKey) {
        String newKey = "key_" + langKey;
        if (compound.func_74764_b(oldKey)) {
            LOGGER.info("Remapping {} to {}", (Object)oldKey, (Object)langKey);
            compound.func_74778_a(newKey, compound.func_74779_i(oldKey));
            compound.func_82580_o(oldKey);
        }
        try {
            String translated = "key_Mekanism " + LangUtils.localize(langKey);
            if (compound.func_74764_b(translated)) {
                LOGGER.info("Remapping {} to {}", (Object)translated, (Object)langKey);
                compound.func_74778_a(newKey, compound.func_74779_i(translated));
                compound.func_82580_o(translated);
            }
        }
        catch (Exception e) {
            LOGGER.error("Remap error", (Throwable)e);
        }
    }
}

