/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.IllegalFormatException;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fluids.FluidStack;

public final class LangUtils {
    public static String transOnOff(boolean b) {
        return LangUtils.localize(LangUtils.transOnOffKey(b));
    }

    public static String transOnOffKey(boolean b) {
        return "gui." + (b ? "on" : "off");
    }

    public static String transYesNo(boolean b) {
        return LangUtils.localize("tooltip." + (b ? "yes" : "no"));
    }

    public static String transOutputInput(boolean b) {
        return LangUtils.localize("gui." + (b ? "output" : "input"));
    }

    public static String localizeFluidStack(FluidStack fluidStack) {
        return fluidStack == null || fluidStack.getFluid() == null ? null : fluidStack.getFluid().getLocalizedName(fluidStack);
    }

    public static String localize(String s) {
        return I18n.func_74838_a((String)s);
    }

    public static String localizeWithFormat(String key, Object ... format) {
        String s = LangUtils.localize(key);
        try {
            return String.format(s, format);
        }
        catch (IllegalFormatException e) {
            return "Format error: " + s;
        }
    }

    public static TextComponentTranslation translationWithColour(String langKey, TextFormatting color) {
        TextComponentTranslation translation = new TextComponentTranslation(langKey, new Object[0]);
        translation.func_150256_b().func_150238_a(color);
        return translation;
    }

    public static <T extends ITextComponent> T withColor(T component, TextFormatting color) {
        component.func_150256_b().func_150238_a(color);
        return component;
    }

    public static TextComponentTranslation onOffColoured(boolean isOn) {
        TextComponentTranslation translation = new TextComponentTranslation(LangUtils.transOnOffKey(isOn), new Object[0]);
        translation.func_150256_b().func_150238_a(isOn ? TextFormatting.DARK_GREEN : TextFormatting.DARK_RED);
        return translation;
    }
}

