/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.handler;

import asmodeuscore.core.astronomy.gui.screen.NewGuiCelestialSelection;
import galaxyspace.systems.SolarSystem.SolarSystemBodies;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.event.client.CelestialBodyRenderEvent;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.Sys;
import org.lwjgl.opengl.GL11;

public class GSMapHandler {
    private static final ResourceLocation haumeaRingTexture = new ResourceLocation("galaxyspace", "textures/gui/celestialbodies/sol/haumea_rings.png");
    final Minecraft minecraft = FMLClientHandler.instance().getClient();
    public Random rand;

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onBodyRender(CelestialBodyRenderEvent.Pre renderEvent) {
        if (renderEvent.celestialBody.equals((Object)SolarSystemBodies.planetKuiperBelt)) {
            GL11.glRotatef((float)((float)Sys.getTime() / 10.0f % 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if (renderEvent.celestialBody.equals((Object)SolarSystemBodies.planetHaumea)) {
            GL11.glRotatef((float)((float)Sys.getTime() / 1000.0f % 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if (renderEvent.celestialBody.getRingColorR() == 1.0f && renderEvent.celestialBody.getRingColorG() == 0.0f && renderEvent.celestialBody.getRingColorB() == 0.0f) {
            GL11.glRotatef((float)((float)Sys.getTime() / 10.0f % 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderPlanetPost(CelestialBodyRenderEvent.Post event) {
        if (this.minecraft.field_71462_r instanceof NewGuiCelestialSelection) {
            if (event.celestialBody == SolarSystemBodies.planetSaturn) {
                this.minecraft.field_71446_o.func_110577_a(ClientProxyCore.saturnRingTexture);
                float size = (float)((NewGuiCelestialSelection)this.minecraft.field_71462_r).getWidthForCelestialBody(event.celestialBody) / 6.0f;
                ((NewGuiCelestialSelection)this.minecraft.field_71462_r).drawTexturedModalRect(-7.5f * size, -1.75f * size, 16.0f * size, 3.5f * size, 0.0f, 0.0f, 30.0f, 2.0f, false, false, 30.0f, 7.0f);
            } else if (event.celestialBody == SolarSystemBodies.planetUranus) {
                this.minecraft.field_71446_o.func_110577_a(ClientProxyCore.uranusRingTexture);
                float size = (float)((NewGuiCelestialSelection)this.minecraft.field_71462_r).getWidthForCelestialBody(event.celestialBody) / 6.0f;
                ((NewGuiCelestialSelection)this.minecraft.field_71462_r).drawTexturedModalRect(-1.75f * size, -7.0f * size, 8.5f * size, 16.0f * size, 0.0f, 0.0f, 28.0f, 7.0f, false, false, 28.0f, 7.0f);
            } else if (event.celestialBody == SolarSystemBodies.planetHaumea) {
                this.minecraft.field_71446_o.func_110577_a(haumeaRingTexture);
                float size = (float)((NewGuiCelestialSelection)this.minecraft.field_71462_r).getWidthForCelestialBody(event.celestialBody) / 6.0f;
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                ((NewGuiCelestialSelection)this.minecraft.field_71462_r).drawTexturedModalRect(-4.45f * size, -8.0f * size, 9.5f * size, 16.0f * size, 0.0f, 0.0f, 28.0f, 7.0f, false, false, 28.0f, 7.0f);
            }
        }
    }
}

