/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.moons.io.world.gen.dungeon;

import asmodeuscore.core.astronomy.dimension.world.gen.dungeons.standart.DungeonConfiguration;
import galaxyspace.systems.SolarSystem.moons.io.world.gen.dungeon.DungeonStartIo;
import galaxyspace.systems.SolarSystem.moons.io.world.gen.dungeon.PieceIo;
import galaxyspace.systems.SolarSystem.moons.io.world.gen.dungeon.RoomBossIo;
import galaxyspace.systems.SolarSystem.moons.io.world.gen.dungeon.RoomChestIo;
import galaxyspace.systems.SolarSystem.moons.io.world.gen.dungeon.RoomEmptyIo;
import galaxyspace.systems.SolarSystem.moons.io.world.gen.dungeon.RoomSpawnerIo;
import galaxyspace.systems.SolarSystem.moons.io.world.gen.dungeon.SizedPieceIo;
import java.lang.reflect.Constructor;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class CorridorIo
extends SizedPieceIo {
    private DungeonConfiguration configuration;

    public CorridorIo() {
    }

    public CorridorIo(DungeonConfiguration configuration, Random rand, int blockPosX, int blockPosZ, int sizeX, int sizeY, int sizeZ, EnumFacing direction) {
        super(configuration, sizeX, sizeY, sizeZ, direction);
        this.configuration = configuration;
        this.func_186164_a(EnumFacing.SOUTH);
        this.field_74887_e = new StructureBoundingBox(blockPosX, configuration.getYPosition(), blockPosZ, blockPosX + sizeX, configuration.getYPosition() + sizeY, blockPosZ + sizeZ);
    }

    public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
        if (this.configuration == null) {
            return false;
        }
        for (int i = 0; i < this.field_74887_e.func_78883_b(); ++i) {
            for (int j = 0; j < this.field_74887_e.func_78882_c(); ++j) {
                for (int k = 0; k < this.field_74887_e.func_78880_d(); ++k) {
                    if (this.getDirection().func_176740_k() == EnumFacing.Axis.Z && (i == 0 || i == 1 || i == this.field_74887_e.func_78883_b() - 1 || i == this.field_74887_e.func_78883_b() - 2) || j == 0 || j == this.field_74887_e.func_78882_c() - 1 || this.getDirection().func_176740_k() == EnumFacing.Axis.X && (k == 0 || k == 1 || k == this.field_74887_e.func_78880_d() - 1 || k == this.field_74887_e.func_78880_d() - 2)) {
                        if (j == this.configuration.getHallwayHeight()) {
                            this.func_175811_a(worldIn, this.configuration.getOtherBlock(false), i, j, k, this.field_74887_e);
                        } else if (j == 0) {
                            this.func_175811_a(worldIn, this.configuration.getOtherBlock(true), i, j, k, this.field_74887_e);
                        } else {
                            this.func_175811_a(worldIn, this.configuration.getBrickBlock(), i, j, k, this.field_74887_e);
                        }
                    } else {
                        this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), i, j, k, this.field_74887_e);
                    }
                    if (this.getDirection().func_176740_k() == EnumFacing.Axis.Z && (k + 1) % 8 == 0 && k != this.field_74887_e.func_78880_d() - 1) {
                        if (j == 2) {
                            if (i == 0 || i == this.field_74887_e.func_78883_b() - 1) {
                                this.func_175811_a(worldIn, Blocks.field_150353_l.func_176223_P(), i, j, k, this.field_74887_e);
                            } else if (i == 1 || i == this.field_74887_e.func_78883_b() - 2) {
                                this.func_175811_a(worldIn, Blocks.field_150411_aY.func_176223_P(), i, j, k, this.field_74887_e);
                            }
                        }
                        if (this.field_74887_e.func_78883_b() < 10 || i != 3 && i != this.field_74887_e.func_78883_b() - 1 - 3) continue;
                        this.func_175811_a(worldIn, this.configuration.getBrickBlock(), i, j, k, this.field_74887_e);
                        continue;
                    }
                    if (this.getDirection().func_176740_k() != EnumFacing.Axis.X || (i + 1) % 8 != 0 || i == this.field_74887_e.func_78883_b() - 1) continue;
                    if (j == 2) {
                        if (k == 0 || k == this.field_74887_e.func_78880_d() - 1) {
                            this.func_175811_a(worldIn, Blocks.field_150353_l.func_176223_P(), i, j, k, this.field_74887_e);
                        } else if (k == 1 || k == this.field_74887_e.func_78880_d() - 2) {
                            this.func_175811_a(worldIn, Blocks.field_150411_aY.func_176223_P(), i, j, k, this.field_74887_e);
                        }
                    }
                    if (this.field_74887_e.func_78880_d() < 10 || k != 3 && k != this.field_74887_e.func_78880_d() - 1 - 3) continue;
                    this.func_175811_a(worldIn, this.configuration.getBrickBlock(), i, j, k, this.field_74887_e);
                }
            }
        }
        return true;
    }

    private <T extends SizedPieceIo> T getRoom(Class<?> clazz, DungeonStartIo startPiece, Random rand) {
        try {
            Constructor<?> c0 = clazz.getConstructor(DungeonConfiguration.class, Random.class, Integer.TYPE, Integer.TYPE, EnumFacing.class);
            SizedPieceIo dummy = (SizedPieceIo)((Object)c0.newInstance(this.configuration, rand, 0, 0, this.getDirection().func_176734_d()));
            StructureBoundingBox extension = this.getExtension(this.getDirection(), this.getDirection().func_176740_k() == EnumFacing.Axis.X ? dummy.getSizeX() : dummy.getSizeZ(), this.getDirection().func_176740_k() == EnumFacing.Axis.X ? dummy.getSizeZ() : dummy.getSizeX());
            if (startPiece.checkIntersection(extension)) {
                return null;
            }
            int sizeX = extension.field_78893_d - extension.field_78897_a;
            int sizeZ = extension.field_78892_f - extension.field_78896_c;
            int sizeY = dummy.getSizeY();
            int blockX = extension.field_78897_a;
            int blockZ = extension.field_78896_c;
            Constructor<?> c1 = clazz.getConstructor(DungeonConfiguration.class, Random.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, EnumFacing.class);
            return (T)((Object)((SizedPieceIo)((Object)c1.newInstance(this.configuration, rand, blockX, blockZ, sizeX, sizeY, sizeZ, this.getDirection().func_176734_d()))));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public PieceIo getNextPiece(DungeonStartIo startPiece, Random rand) {
        if (startPiece.attachedComponents.size() > 2 && startPiece.attachedComponents.get(startPiece.attachedComponents.size() - 2) instanceof RoomBossIo) {
            try {
                return this.getRoom(this.configuration.getTreasureRoom(), startPiece, rand);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            boolean bossRoom;
            int bossRoomChance = Math.max((int)(1.0 / Math.pow((double)startPiece.attachedComponents.size() / 55.0, 2.0)), 5);
            boolean bl = bossRoom = rand.nextInt(bossRoomChance) == 0;
            if (bossRoom) {
                try {
                    return this.getRoom(this.configuration.getBossRoom(), startPiece, rand);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                PieceIo lastPiece;
                StructureBoundingBox extension = this.getExtension(this.getDirection(), rand.nextInt(4) + 10, rand.nextInt(4) + 10);
                if (startPiece.checkIntersection(extension)) {
                    return null;
                }
                int sizeX = extension.field_78893_d - extension.field_78897_a;
                int sizeZ = extension.field_78892_f - extension.field_78896_c;
                int sizeY = this.configuration.getRoomHeight();
                int blockX = extension.field_78897_a;
                int blockZ = extension.field_78896_c;
                if (Math.abs(startPiece.func_74874_b().field_78892_f - this.field_74887_e.field_78896_c) > 200) {
                    return null;
                }
                if (Math.abs(startPiece.func_74874_b().field_78893_d - this.field_74887_e.field_78897_a) > 200) {
                    return null;
                }
                PieceIo pieceIo = lastPiece = startPiece.attachedComponents.size() <= 2 ? null : (PieceIo)startPiece.attachedComponents.get(startPiece.attachedComponents.size() - 2);
                if (!(lastPiece instanceof RoomSpawnerIo)) {
                    return new RoomSpawnerIo(this.configuration, rand, blockX, blockZ, sizeX, sizeY, sizeZ, this.getDirection().func_176734_d());
                }
                if (rand.nextInt(2) == 0) {
                    return new RoomEmptyIo(this.configuration, rand, blockX, blockZ, sizeX, sizeY, sizeZ, this.getDirection().func_176734_d());
                }
                return new RoomChestIo(this.configuration, rand, blockX, blockZ, sizeX, sizeY, sizeZ, this.getDirection().func_176734_d());
            }
        }
        return null;
    }
}

