/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.overworld.tile;

import galaxyspace.core.GSFluids;
import galaxyspace.core.prefab.tile.TileEntityUpgradeMachine;
import galaxyspace.core.util.GSUtils;
import galaxyspace.systems.SolarSystem.planets.overworld.blocks.machines.BlockUniversalRecycler;
import galaxyspace.systems.SolarSystem.planets.overworld.recipes.RecyclerRecipes;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.wrappers.FluidHandlerWrapper;
import micdoodle8.mods.galacticraft.core.wrappers.IFluidHandlerWrapper;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityUniversalRecycler
extends TileEntityUpgradeMachine
implements IFluidHandlerWrapper,
ISidedInventory,
IPacketReceiver {
    public static final int PROCESS_TIME_REQUIRED_BASE = 130;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTimeRequired = 130;
    private final int tankCapacity = 3000;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank waterTank = new FluidTank(this.tankCapacity);

    public TileEntityUniversalRecycler() {
        super("tile.universal_recycler.name");
        this.storage.setCapacity(20000.0f);
        this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 90.0f : 75.0f);
        this.inventory = NonNullList.func_191197_a((int)10, (Object)ItemStack.field_190927_a);
        this.setTierGC(1);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            boolean isWater;
            FluidStack liquid;
            GSUtils.checkFluidTankTransfer((NonNullList<ItemStack>)this.getInventory(), 2, this.waterTank);
            if (!((ItemStack)this.getInventory().get(4)).func_190926_b() && (liquid = FluidUtil.getFluidContained((ItemStack)((ItemStack)this.getInventory().get(4)))) != null && (isWater = FluidRegistry.getFluidName((FluidStack)liquid).startsWith("liquidethanemethane")) && (this.waterTank.getFluid() == null || this.waterTank.getFluid().amount + liquid.amount <= this.waterTank.getCapacity())) {
                this.waterTank.fill(new FluidStack(GSFluids.LiquidEthaneMethane, liquid.amount), true);
                if (micdoodle8.mods.galacticraft.core.util.FluidUtil.isBucket((ItemStack)((ItemStack)this.getInventory().get(4))) && micdoodle8.mods.galacticraft.core.util.FluidUtil.isFilledContainer((ItemStack)((ItemStack)this.getInventory().get(4)))) {
                    int amount = ((ItemStack)this.getInventory().get(4)).func_190916_E();
                    if (amount > 1) {
                        this.waterTank.fill(new FluidStack(GSFluids.LiquidEthaneMethane, (amount - 1) * 1000), true);
                    }
                    this.getInventory().set(4, (Object)new ItemStack(Items.field_151133_ar, amount));
                } else {
                    ((ItemStack)this.getInventory().get(4)).func_190918_g(1);
                    if (((ItemStack)this.getInventory().get(4)).func_190916_E() == 0) {
                        this.getInventory().set(4, (Object)ItemStack.field_190927_a);
                    }
                }
            }
            if (this.canProcess()) {
                if (this.hasEnoughEnergyToRun && this.processTicks >= this.processTimeRequired) {
                    this.smeltItem();
                    this.processTicks = 0;
                }
            } else {
                this.processTicks = 0;
            }
        }
    }

    @Override
    public boolean canProcess() {
        if (((ItemStack)this.getInventory().get(1)).func_190926_b()) {
            return false;
        }
        ItemStack input = (ItemStack)this.getInventory().get(1);
        RecyclerRecipes.RecycleRecipe recipe = RecyclerRecipes.recycling().getRecipe(input);
        if (recipe != null) {
            if (input.func_190916_E() < recipe.getInput().func_190916_E()) {
                return false;
            }
            if (recipe.getFluidStack() != null) {
                if (this.waterTank.getFluidAmount() > 0 && !this.waterTank.getFluid().isFluidEqual(recipe.getFluidStack())) {
                    return false;
                }
                if (this.waterTank.getFluidAmount() >= this.waterTank.getCapacity()) {
                    return false;
                }
            }
            if (!recipe.getOutput().func_190926_b()) {
                if (!((ItemStack)this.getInventory().get(3)).func_190926_b() && !((ItemStack)this.getInventory().get(3)).func_77969_a(recipe.getOutput())) {
                    return false;
                }
                int result = ((ItemStack)this.getInventory().get(3)).func_190916_E() + recipe.getOutput().func_190916_E();
                return result <= this.func_70297_j_() && result <= ((ItemStack)this.getInventory().get(3)).func_77976_d();
            }
            if (!recipe.getOutput_2().func_190926_b()) {
                if (!((ItemStack)this.getInventory().get(4)).func_190926_b() && !((ItemStack)this.getInventory().get(4)).func_77969_a(recipe.getOutput_2())) {
                    return false;
                }
                int result = ((ItemStack)this.getInventory().get(4)).func_190916_E() + recipe.getOutput_2().func_190916_E();
                return result <= this.func_70297_j_() && result <= ((ItemStack)this.getInventory().get(4)).func_77976_d();
            }
        } else {
            return false;
        }
        return true;
    }

    public void smeltItem() {
        if (this.canProcess()) {
            ItemStack input = (ItemStack)this.getInventory().get(1);
            RecyclerRecipes.RecycleRecipe recipe = RecyclerRecipes.recycling().getRecipe(input);
            if (recipe != null) {
                boolean hasRand = recipe.hasChance();
                boolean hasRand_2 = recipe.hasChance_2();
                if (!hasRand) {
                    if (((ItemStack)this.getInventory().get(3)).func_190926_b()) {
                        this.getInventory().set(3, (Object)recipe.getOutput().func_77946_l());
                    } else if (((ItemStack)this.getInventory().get(3)).func_77969_a(recipe.getOutput())) {
                        ((ItemStack)this.getInventory().get(3)).func_190917_f(recipe.getOutput().func_190916_E());
                    }
                    if (!hasRand_2 && !recipe.getOutput_2().func_190926_b()) {
                        if (((ItemStack)this.getInventory().get(4)).func_190926_b()) {
                            this.getInventory().set(4, (Object)recipe.getOutput_2().func_77946_l());
                        } else if (((ItemStack)this.getInventory().get(4)).func_77969_a(recipe.getOutput_2())) {
                            ((ItemStack)this.getInventory().get(4)).func_190917_f(recipe.getOutput_2().func_190916_E());
                        }
                    }
                } else if (this.field_145850_b.field_73012_v.nextInt(100) <= recipe.getChance()) {
                    if (((ItemStack)this.getInventory().get(3)).func_190926_b()) {
                        this.getInventory().set(3, (Object)recipe.getOutput().func_77946_l());
                    } else if (((ItemStack)this.getInventory().get(3)).func_77969_a(recipe.getOutput())) {
                        ((ItemStack)this.getInventory().get(3)).func_190917_f(recipe.getOutput().func_190916_E());
                    }
                    if (recipe.getOutput_2() != null && !recipe.getOutput_2().func_190926_b() && this.field_145850_b.field_73012_v.nextInt(100) <= recipe.getChance_2()) {
                        if (((ItemStack)this.getInventory().get(4)).func_190926_b()) {
                            this.getInventory().set(4, (Object)recipe.getOutput_2().func_77946_l());
                        } else if (((ItemStack)this.getInventory().get(4)).func_77969_a(recipe.getOutput_2())) {
                            ((ItemStack)this.getInventory().get(4)).func_190917_f(recipe.getOutput_2().func_190916_E());
                        }
                    }
                }
                ((ItemStack)this.getInventory().get(1)).func_190918_g(recipe.getInput().func_190916_E());
                if (recipe.getFluidStack() != null) {
                    this.waterTank.fill(new FluidStack(recipe.getFluidStack().getFluid(), recipe.getFluidStack().amount > this.waterTank.getCapacity() ? this.waterTank.getCapacity() : recipe.getFluidStack().amount), true);
                }
            }
        }
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.processTicks = par1NBTTagCompound.func_74762_e("smeltingTicks");
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)par1NBTTagCompound, (NonNullList)this.getInventory());
        if (par1NBTTagCompound.func_74764_b("waterTank")) {
            this.waterTank.readFromNBT(par1NBTTagCompound.func_74775_l("waterTank"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound par1NBTTagCompound) {
        super.func_189515_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("smeltingTicks", this.processTicks);
        ItemStackHelper.func_191282_a((NBTTagCompound)par1NBTTagCompound, (NonNullList)this.getInventory());
        if (this.waterTank.getFluid() != null) {
            par1NBTTagCompound.func_74782_a("waterTank", (NBTBase)this.waterTank.writeToNBT(new NBTTagCompound()));
        }
        return par1NBTTagCompound;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1, 3, 4};
    }

    public boolean func_180462_a(int slotID, ItemStack itemstack, EnumFacing side) {
        return this.func_94041_b(slotID, itemstack);
    }

    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        return slotID == 3;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        switch (slotID) {
            case 0: {
                return ItemElectricBase.isElectricItem((Item)itemstack.func_77973_b());
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldUseEnergy() {
        return this.canProcess();
    }

    public ItemStack getBatteryInSlot() {
        return this.func_70301_a(0);
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        if (from == this.getPipe() && resource != null && resource.isFluidEqual(this.waterTank.getFluid())) {
            return this.waterTank.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        if (from == this.getPipe()) {
            return this.waterTank.drain(maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        if (from == this.getPipe()) {
            return this.waterTank.getFluid() != null && this.waterTank.getFluidAmount() > 0;
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.waterTank)};
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)new FluidHandlerWrapper((IFluidHandlerWrapper)this, facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    private EnumFacing getPipe() {
        return this.getFront().func_176735_f();
    }

    public EnumFacing getElectricInputDirection() {
        return this.getFront().func_176746_e();
    }

    public EnumFacing getFront() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockUniversalRecycler) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockUniversalRecycler.FACING);
        }
        return EnumFacing.NORTH;
    }

    public boolean canConnect(EnumFacing direction, NetworkType type) {
        if (direction == null) {
            return false;
        }
        if (type == NetworkType.POWER) {
            return direction == this.getElectricInputDirection();
        }
        if (type == NetworkType.FLUID) {
            EnumFacing pipeSide = this.getPipe();
            return direction == pipeSide;
        }
        return false;
    }

    public int getScaledTankLevel(int i) {
        return this.waterTank.getFluidAmount() * i / this.waterTank.getCapacity();
    }

    @Override
    public int[] upgradeSlots() {
        return new int[]{5, 6, 7, 8};
    }
}

