/*
 * Decompiled with CFR 0.152.
 */
package com.universeguard.command;

import com.universeguard.region.LocalRegion;
import com.universeguard.region.enums.EnumRegionFlag;
import com.universeguard.region.enums.RegionText;
import com.universeguard.utils.MessageUtils;
import com.universeguard.utils.RegionUtils;
import java.util.ArrayList;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class RegionAtExecutor
implements CommandExecutor {
    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        if (args.hasAny("location")) {
            Location location = (Location)args.getOne("location").get();
            ArrayList<LocalRegion> regions = RegionUtils.getAllLocalRegionsAt((Location<World>)location);
            String regionList = "";
            for (LocalRegion region : regions) {
                if (region.getFlag(EnumRegionFlag.HIDE_REGION)) continue;
                regionList = regionList + region.getName() + ", ";
            }
            if (!regionList.isEmpty()) {
                MessageUtils.sendMessage(src, RegionText.REGION.getValue() + ": " + regionList.substring(0, regionList.length() - 2), TextColors.GREEN);
            } else {
                MessageUtils.sendErrorMessage(src, RegionText.NO_REGION_AT.getValue());
            }
        } else {
            MessageUtils.sendErrorMessage(src, this.getCommandUsage());
        }
        return CommandResult.empty();
    }

    private String getCommandUsage() {
        return "/rg at <location>";
    }
}

