/*
 * Decompiled with CFR 0.152.
 */
package com.universeguard.command;

import com.universeguard.region.Region;
import com.universeguard.region.enums.RegionText;
import com.universeguard.utils.MessageUtils;
import com.universeguard.utils.RegionUtils;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.player.gamemode.GameModes;

public class RegionGamemodeExecutor
implements CommandExecutor {
    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        if (RegionUtils.hasPendingRegion(src)) {
            if (args.hasAny("gamemode")) {
                GameMode gameMode = (GameMode)args.getOne("gamemode").get();
                if (gameMode != GameModes.NOT_SET) {
                    Region region = RegionUtils.getPendingRegion(src);
                    region.setGamemode(gameMode.getId());
                    MessageUtils.sendSuccessMessage(src, RegionText.REGION_GAMEMODE_UPDATED.getValue());
                    RegionUtils.updatePendingRegion(src, region);
                } else {
                    MessageUtils.sendErrorMessage(src, RegionText.REGION_GAMEMODE_NOT_VALID.getValue());
                }
            } else {
                MessageUtils.sendErrorMessage(src, this.getCommandUsage());
            }
        } else {
            MessageUtils.sendErrorMessage(src, RegionText.NO_PENDING_REGION.getValue());
        }
        return CommandResult.empty();
    }

    private String getCommandUsage() {
        return "/rg gamemode <gamemode>";
    }
}

