/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.renderers.tile;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.client.lib.obj.AdvancedModelLoader;
import thaumcraft.client.lib.obj.IModelCustom;
import thaumcraft.common.lib.utils.BlockStateUtils;
import thaumcraft.common.tiles.crafting.TileGolemBuilder;

@SideOnly(value=Side.CLIENT)
public class TileGolemBuilderRenderer
extends TileEntitySpecialRenderer {
    private IModelCustom model = AdvancedModelLoader.loadModel(TM);
    private static final ResourceLocation TM = new ResourceLocation("thaumcraft", "models/block/golembuilder.obj");
    private static final ResourceLocation TEX = new ResourceLocation("thaumcraft", "textures/blocks/golembuilder.png");
    EntityItem entityitem = null;

    public void renderTileEntityAt(TileGolemBuilder tile, double par2, double par4, double par6, float pt, int destroyStage) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)par2 + 0.5f), (float)((float)par4), (float)((float)par6 + 0.5f));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_147499_a(TEX);
        if (destroyStage >= 0) {
            this.func_147499_a(field_178460_a[destroyStage]);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)5.0f, (float)5.0f, (float)2.0f);
            GlStateManager.func_179109_b((float)0.0625f, (float)0.0625f, (float)0.0625f);
            GlStateManager.func_179128_n((int)5888);
        } else {
            GL11.glMatrixMode((int)5890);
            GL11.glLoadIdentity();
            GL11.glScalef((float)1.0f, (float)-1.0f, (float)1.0f);
            GL11.glMatrixMode((int)5888);
        }
        EnumFacing facing = BlockStateUtils.getFacing(tile.func_145832_p());
        if (tile.func_145831_w() != null) {
            switch (facing.ordinal()) {
                case 5: {
                    GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case 4: {
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case 3: {
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
            }
        }
        this.model.renderAllExcept("press");
        GL11.glPushMatrix();
        float h = tile.press;
        double s = Math.sin(Math.toRadians(h)) * 0.625;
        GL11.glTranslated((double)0.0, (double)(-s), (double)0.0);
        this.model.renderPart("press");
        GL11.glPopMatrix();
        if (destroyStage >= 0) {
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
        } else {
            GL11.glMatrixMode((int)5890);
            GL11.glLoadIdentity();
            GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glMatrixMode((int)5888);
        }
        GL11.glTranslatef((float)-0.3125f, (float)0.625f, (float)1.3125f);
        GL11.glRotatef((float)90.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
        TextureAtlasSprite icon = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(Blocks.field_150353_l.func_176223_P());
        UtilsFX.renderQuadFromIcon(icon, 0.625f, 1.0f, 1.0f, 1.0f, 200, 771, 1.0f);
        GL11.glPopMatrix();
    }

    public void func_192841_a(TileEntity te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        super.func_192841_a(te, x, y, z, partialTicks, destroyStage, alpha);
        this.renderTileEntityAt((TileGolemBuilder)te, x, y, z, partialTicks, destroyStage);
    }
}

