/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.forestry;

import com.blamejared.ModTweaker;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.helpers.StackHelper;
import com.blamejared.mtlib.utils.BaseAddForestry;
import com.blamejared.mtlib.utils.BaseRemoveForestry;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.WeightedItemStack;
import forestry.api.recipes.ICentrifugeRecipe;
import forestry.api.recipes.ICraftingProvider;
import forestry.api.recipes.IForestryRecipe;
import forestry.api.recipes.RecipeManagers;
import forestry.factory.recipes.CentrifugeRecipe;
import java.util.HashMap;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.forestry.Centrifuge")
@ModOnly(value="forestry")
@ZenRegister
public class Centrifuge {
    public static final String name = "Forestry Centrifuge";

    @ZenMethod
    public static void addRecipe(WeightedItemStack[] output, IItemStack ingredients, int packagingTime) {
        HashMap<ItemStack, Float> products = new HashMap<ItemStack, Float>();
        for (WeightedItemStack product : output) {
            products.put(InputHelper.toStack((IItemStack)product.getStack()), Float.valueOf(product.getChance()));
        }
        ModTweaker.LATE_ADDITIONS.add((IAction)new Add((ICentrifugeRecipe)new CentrifugeRecipe(packagingTime, InputHelper.toStack((IItemStack)ingredients), products)));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient input) {
        ModTweaker.LATE_REMOVALS.add((IAction)new Remove(input));
    }

    private static class Remove
    extends BaseRemoveForestry<ICentrifugeRecipe> {
        private IIngredient input;

        public Remove(IIngredient input) {
            super(Centrifuge.name, (ICraftingProvider)RecipeManagers.centrifugeManager);
            this.input = input;
        }

        protected String getRecipeInfo() {
            return this.input.toString();
        }

        public boolean checkIsRecipe(ICentrifugeRecipe recipe) {
            return recipe != null && StackHelper.matches((IIngredient)this.input, (IItemStack)InputHelper.toIItemStack((ItemStack)recipe.getInput()));
        }
    }

    private static class Add
    extends BaseAddForestry<ICentrifugeRecipe> {
        public Add(ICentrifugeRecipe recipe) {
            super(Centrifuge.name, (ICraftingProvider)RecipeManagers.centrifugeManager, (IForestryRecipe)recipe);
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((Object)((ICentrifugeRecipe)this.recipe).getInput());
        }
    }
}

