/*
 * Decompiled with CFR 0.152.
 */
package com.carrot.carrotshop.shop;

import com.carrot.carrotshop.CarrotShop;
import com.carrot.carrotshop.Lang;
import com.carrot.carrotshop.ShopsData;
import com.carrot.carrotshop.ShopsLogs;
import com.carrot.carrotshop.shop.Shop;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import org.spongepowered.api.block.tileentity.carrier.TileEntityCarrier;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.query.QueryOperation;
import org.spongepowered.api.item.inventory.query.QueryOperationTypes;
import org.spongepowered.api.item.inventory.type.InventoryRow;
import org.spongepowered.api.item.inventory.type.TileEntityInventory;
import org.spongepowered.api.service.economy.account.UniqueAccount;
import org.spongepowered.api.service.economy.transaction.ResultType;
import org.spongepowered.api.service.economy.transaction.TransactionResult;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@ConfigSerializable
public class aSell
extends Shop {
    @Setting
    private Inventory itemsTemplate;
    @Setting
    private Location<World> sellerChest;
    @Setting
    private float price;
    private static String type = "aSell";

    public aSell() {
    }

    public aSell(Player player, Location<World> sign) throws ExceptionInInitializerError {
        super(sign);
        if (!player.hasPermission("carrotshop.admin.asell")) {
            throw new ExceptionInInitializerError(Lang.SHOP_PERM.replace("%type%", type));
        }
        Stack<Location<World>> locations = ShopsData.getItemLocations(player);
        if (locations.isEmpty()) {
            throw new ExceptionInInitializerError(Lang.SHOP_CHEST.replace("%type%", type));
        }
        Optional chestOpt = locations.peek().getTileEntity();
        if (!chestOpt.isPresent() || !(chestOpt.get() instanceof TileEntityCarrier)) {
            throw new ExceptionInInitializerError(Lang.SHOP_CHEST.replace("%type%", type));
        }
        TileEntityInventory items = ((TileEntityCarrier)chestOpt.get()).getInventory();
        if (items.totalItems() == 0) {
            throw new ExceptionInInitializerError(Lang.SHOP_CHEST_EMPTY);
        }
        this.price = aSell.getPrice(sign);
        if (this.price < 0.0f) {
            throw new ExceptionInInitializerError(Lang.SHOP_PRICE);
        }
        this.sellerChest = locations.peek();
        this.itemsTemplate = ((Inventory.Builder)Inventory.builder().from((Object)items)).build((Object)CarrotShop.getInstance());
        for (Inventory item : items.slots()) {
            if (!item.peek().isPresent()) continue;
            this.itemsTemplate.offer((ItemStack)item.peek().get());
        }
        ShopsData.clearItemLocations(player);
        player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, Lang.SHOP_DONE.replace("%type%", type)}));
        this.done(player);
        this.info(player);
    }

    @Override
    public List<Location<World>> getLocations() {
        List<Location<World>> locations = super.getLocations();
        locations.add(this.sellerChest);
        return locations;
    }

    @Override
    public boolean update() {
        TileEntityInventory chestInv;
        Optional chest = this.sellerChest.getTileEntity();
        if (chest.isPresent() && chest.get() instanceof TileEntityCarrier && (chestInv = ((TileEntityCarrier)chest.get()).getInventory()).capacity() - chestInv.size() >= this.itemsTemplate.size()) {
            this.setOK();
            return true;
        }
        this.setFail();
        return false;
    }

    @Override
    public void info(Player player) {
        Text.Builder builder = Text.builder();
        builder.append(new Text[]{Text.of((String)Lang.split(Lang.SHOP_FORMAT_SELL, "%items%", 0).replace("%price%", this.formatPrice(this.price)))});
        builder.append(new Text[]{aSell.formatInventoryNames(this.itemsTemplate)});
        builder.append(new Text[]{Text.of((String)Lang.split(Lang.SHOP_FORMAT_SELL, "%items%", 1).replace("%price%", this.formatPrice(this.price)))});
        player.sendMessage(builder.build());
        if (!this.update()) {
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.GOLD, Lang.SHOP_FULL}));
        }
    }

    @Override
    public boolean trigger(Player player) {
        TileEntityInventory chestInv;
        Inventory inv = player.getInventory().query(new QueryOperation[]{QueryOperationTypes.INVENTORY_TYPE.of(InventoryRow.class)});
        if (!aSell.hasEnough(inv, this.itemsTemplate)) {
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_RED, Lang.SHOP_ITEMS}));
            return false;
        }
        Optional chest = this.sellerChest.getTileEntity();
        if (chest.isPresent() && chest.get() instanceof TileEntityCarrier && (chestInv = ((TileEntityCarrier)chest.get()).getInventory()).capacity() - chestInv.size() < this.itemsTemplate.size()) {
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.GOLD, Lang.SHOP_FULL}));
            this.update();
            return false;
        }
        TileEntityInventory invChest = ((TileEntityCarrier)chest.get()).getInventory();
        for (Inventory item : this.itemsTemplate.slots()) {
            Optional<ItemStack> template;
            if (!item.peek().isPresent() || !(template = aSell.getTemplate(inv, (ItemStack)item.peek().get())).isPresent()) continue;
            Optional items = inv.query(new QueryOperation[]{QueryOperationTypes.ITEM_STACK_IGNORE_QUANTITY.of((Object)template.get())}).poll(((ItemStack)item.peek().get()).getQuantity());
            if (items.isPresent()) {
                invChest.offer((ItemStack)items.get());
                continue;
            }
            return false;
        }
        UniqueAccount sellerAccount = (UniqueAccount)CarrotShop.getEcoService().getOrCreateAccount(player.getUniqueId()).get();
        TransactionResult result = sellerAccount.deposit(this.getCurrency(), BigDecimal.valueOf(this.price), CarrotShop.getCause());
        if (result.getResult() != ResultType.SUCCESS) {
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_RED, Lang.SHOP_ERROR_MONEY}));
            return false;
        }
        ShopsLogs.log(this.getOwner(), player, "sell", super.getLocation(), Optional.of(Float.valueOf(this.price)), this.getRawCurrency(), Optional.of(this.itemsTemplate), Optional.empty());
        String recap = Lang.SHOP_RECAP_SELL.replace("%price%", this.formatPrice(this.price));
        player.sendMessage(Text.of((Object[])new Object[]{Lang.split(recap, "%items%", 0), aSell.formatInventoryNames(this.itemsTemplate), Lang.split(recap, "%items%", 1)}));
        this.update();
        return true;
    }
}

