/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalinnovation.item;

import cofh.api.item.IMultiModeItem;
import cofh.core.init.CoreEnchantments;
import cofh.core.item.ItemMulti;
import cofh.core.key.KeyBindingItemMultiMode;
import cofh.core.render.IModelRegister;
import cofh.core.util.core.IInitializer;
import cofh.core.util.helpers.ChatHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalfoundation.init.TFProps;
import cofh.thermalinnovation.ThermalInnovation;
import cofh.thermalinnovation.item.ItemMultiRFTool;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPump
extends ItemMultiRFTool
implements IInitializer,
IMultiModeItem {
    private static Int2ObjectOpenHashMap<TypeEntry> typeMap = new Int2ObjectOpenHashMap();
    public static final int CAPACITY_BASE = 40000;
    public static final int XFER_BASE = 1000;
    public static final int ENERGY_PER_USE = 100;
    public static final int[] CAPACITY = new int[]{1, 3, 6, 10, 15};
    public static final int[] XFER = new int[]{1, 4, 9, 16, 25};
    public static final int[] MAX_RADIUS = new int[]{0, 1, 1, 2, 2};
    public static boolean enable = true;
    public static ItemStack pumpBasic;
    public static ItemStack pumpHardened;
    public static ItemStack pumpReinforced;
    public static ItemStack pumpSignalum;
    public static ItemStack pumpResonant;
    public static ItemStack pumpCreative;

    public ItemPump() {
        super("thermalinnovation");
        this.func_77655_b("pump");
        this.func_77637_a(ThermalInnovation.tabTools);
        this.energyPerUse = 100;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        tooltip.add(StringHelper.getInfoText((String)"info.thermalinnovation.pump.a.0"));
        tooltip.add(StringHelper.localize((String)("info.thermalinnovation.pump.c." + this.getMode(stack))));
        tooltip.add(StringHelper.localizeFormat((String)"info.thermalinnovation.pump.b.0", (Object[])new Object[]{StringHelper.getKeyName((int)KeyBindingItemMultiMode.INSTANCE.getKey())}));
        if (ItemPump.isCreative((ItemStack)stack)) {
            tooltip.add(StringHelper.localize((String)"info.cofh.charge") + ": 1.21G RF");
        } else {
            tooltip.add(StringHelper.localize((String)"info.cofh.charge") + ": " + StringHelper.getScaledNumber((long)this.getEnergyStored(stack)) + " / " + StringHelper.getScaledNumber((long)this.getMaxEnergyStored(stack)) + " RF");
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            Iterator iterator = this.itemList.iterator();
            while (iterator.hasNext()) {
                int metadata = (Integer)iterator.next();
                if (metadata != 32000) {
                    if (TFProps.showEmptyItems) {
                        items.add((Object)this.setDefaultTag(new ItemStack((Item)this, 1, metadata), 0));
                    }
                    if (!TFProps.showFullItems) continue;
                    items.add((Object)this.setDefaultTag(new ItemStack((Item)this, 1, metadata), this.getBaseCapacity(metadata)));
                    continue;
                }
                if (!TFProps.showCreativeItems) continue;
                items.add((Object)this.setDefaultTag(new ItemStack((Item)this, 1, metadata), this.getBaseCapacity(metadata)));
            }
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isSelected) {
        if (!this.isActive(stack)) {
            return;
        }
        long activeTime = stack.func_77978_p().func_74763_f("Active");
        if (entity.field_70170_p.func_82737_E() > activeTime) {
            stack.func_77978_p().func_82580_o("Active");
        }
    }

    public int getItemEnchantability(ItemStack stack) {
        return 10;
    }

    protected int getCapacity(ItemStack stack) {
        if (!typeMap.containsKey(ItemHelper.getItemDamage((ItemStack)stack))) {
            return 0;
        }
        int capacity = ((TypeEntry)ItemPump.typeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).capacity;
        int enchant = EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.holding, (ItemStack)stack);
        return capacity + capacity * enchant / 2;
    }

    protected int getReceive(ItemStack stack) {
        if (!typeMap.containsKey(ItemHelper.getItemDamage((ItemStack)stack))) {
            return 0;
        }
        return ((TypeEntry)ItemPump.typeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).recv;
    }

    public int getBaseCapacity(int metadata) {
        if (!typeMap.containsKey(metadata)) {
            return 0;
        }
        return ((TypeEntry)ItemPump.typeMap.get((int)metadata)).capacity;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> {
            Object[] objectArray = new Object[2];
            objectArray[0] = this.getEnergyStored(stack) > 0 ? (this.isActive(stack) ? "active" : "charged") : "drained";
            objectArray[1] = ((TypeEntry)ItemPump.typeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).name;
            return new ModelResourceLocation(this.getRegistryName(), String.format("state=%s,type=%s", objectArray));
        });
        String[] states = new String[]{"charged", "active", "drained"};
        for (Map.Entry entry : this.itemMap.entrySet()) {
            for (int i = 0; i < 3; ++i) {
                ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(this.getRegistryName(), String.format("state=%s,type=%s", states[i], ((ItemMulti.ItemEntry)entry.getValue()).name))});
            }
        }
    }

    public void onModeChange(EntityPlayer player, ItemStack stack) {
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187630_M, SoundCategory.PLAYERS, 0.4f, 0.8f + 0.4f * (float)this.getMode(stack));
        ChatHelper.sendIndexedChatMessageToPlayer((EntityPlayer)player, (ITextComponent)new TextComponentTranslation("info.thermalinnovation.pump.c." + this.getMode(stack), new Object[0]));
    }

    public boolean canEnchant(ItemStack stack, Enchantment enchantment) {
        return ItemHelper.getItemDamage((ItemStack)stack) != 32000 && enchantment == CoreEnchantments.holding;
    }

    public boolean preInit() {
        ForgeRegistries.ITEMS.register(this.setRegistryName("pump"));
        ThermalInnovation.proxy.addIModelRegister((IModelRegister)this);
        ItemPump.config();
        pumpBasic = this.addEntryItem(0, "standard0", 0, EnumRarity.COMMON);
        pumpHardened = this.addEntryItem(1, "standard1", 1, EnumRarity.COMMON);
        pumpReinforced = this.addEntryItem(2, "standard2", 2, EnumRarity.UNCOMMON);
        pumpSignalum = this.addEntryItem(3, "standard3", 3, EnumRarity.UNCOMMON);
        pumpResonant = this.addEntryItem(4, "standard4", 4, EnumRarity.RARE);
        pumpCreative = this.addEntryItem(32000, "creative", CAPACITY[4], 0, 4, EnumRarity.EPIC);
        return true;
    }

    public boolean initialize() {
        return enable;
    }

    private static void config() {
        String category = "Item.Pump";
        enable = ThermalInnovation.CONFIG.get(category, "Enable", true);
        int capacity = 40000;
        String comment = "Adjust this value to change the amount of Energy (in RF) stored by a Basic FluiVac. This base value will scale with item level.";
        capacity = ThermalInnovation.CONFIG.getConfiguration().getInt("BaseCapacity", category, capacity, 10000, 10000000, comment);
        int xfer = 1000;
        comment = "Adjust this value to change the amount of Energy (in RF/t) that can be received by a Basic FluiVac. This base value will scale with item level.";
        xfer = ThermalInnovation.CONFIG.getConfiguration().getInt("BaseReceive", category, xfer, 100, 1000000, comment);
        int i = 0;
        while (i < CAPACITY.length) {
            int n = i;
            CAPACITY[n] = CAPACITY[n] * capacity;
            int n2 = i++;
            XFER[n2] = XFER[n2] * xfer;
        }
    }

    private void addEntry(int metadata, String name, int capacity, int xfer, int level) {
        typeMap.put(metadata, (Object)new TypeEntry(name, capacity, xfer, level));
    }

    private ItemStack addEntryItem(int metadata, String name, int level, EnumRarity rarity) {
        this.addEntry(metadata, name, CAPACITY[metadata], XFER[metadata], level);
        return this.addItem(metadata, name, rarity);
    }

    private ItemStack addEntryItem(int metadata, String name, int capacity, int xfer, int radius, EnumRarity rarity) {
        this.addEntry(metadata, name, capacity, xfer, radius);
        return this.addItem(metadata, name, rarity);
    }

    public class TypeEntry {
        public final String name;
        public final int capacity;
        public final int recv;
        public final int level;

        TypeEntry(String name, int capacity, int recv, int level) {
            this.name = name;
            this.capacity = capacity;
            this.recv = recv;
            this.level = level;
        }
    }
}

