/*
 * Decompiled with CFR 0.152.
 */
package nihiltres.engineersdoors.common.block;

import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nihiltres.engineersdoors.EngineersDoors;
import nihiltres.engineersdoors.common.block.properties.IBlockSetup;
import nihiltres.engineersdoors.common.block.properties.ICustomStateMapped;
import nihiltres.engineersdoors.common.item.IOre;

public class BlockModFencegate
extends BlockFenceGate
implements IBlockSetup,
ICustomStateMapped,
IOre {
    public Item itemBlock;
    private static final ResourceLocation METAL_GATE_OPEN_RL = new ResourceLocation("engineersdoors", "metal_gate_open");
    private static final ResourceLocation METAL_GATE_CLOSE_RL = new ResourceLocation("engineersdoors", "metal_gate_close");
    public static final SoundEvent METAL_GATE_OPEN = (SoundEvent)new SoundEvent(METAL_GATE_OPEN_RL).setRegistryName(METAL_GATE_OPEN_RL);
    public static final SoundEvent METAL_GATE_CLOSE = (SoundEvent)new SoundEvent(METAL_GATE_CLOSE_RL).setRegistryName(METAL_GATE_CLOSE_RL);

    private BlockModFencegate(Material materialIn, @Nonnull String nameIn) {
        super(BlockPlanks.EnumType.DARK_OAK);
        try {
            ReflectionHelper.setPrivateValue(Block.class, (Object)this, (Object)materialIn, (String[])new String[]{"field_149764_J"});
        }
        catch (ReflectionHelper.UnableToAccessFieldException e) {
            EngineersDoors.debug(e);
        }
        if (this.field_149764_J != Material.field_151575_d && this.field_149764_J != Material.field_151573_f) {
            EngineersDoors.debug("Fencegate with unsupported material initialized; it'll use wood sound as default");
        }
        this.func_149672_a(IBlockSetup.EnumMaterialDefaults.getSoundType(materialIn));
        this.setDefaultBlockProperties(materialIn, nameIn).func_149647_a(EngineersDoors.creativeTab);
    }

    public BlockModFencegate(Material materialIn, @Nonnull String nameIn, @Nonnull String oreNameIn) {
        this(materialIn, nameIn);
        this.addOreName(oreNameIn);
        this.itemBlock = IBlockSetup.createItemBlock((Block)this);
    }

    public BlockModFencegate(Material materialIn, @Nonnull String nameIn, Collection<String> oreNamesIn) {
        this(materialIn, nameIn);
        this.addOreNames(oreNamesIn);
        this.itemBlock = IBlockSetup.createItemBlock((Block)this);
    }

    public BlockModFencegate(Material materialIn, @Nonnull String nameIn, String ... oreNamesIn) {
        this(materialIn, nameIn, Arrays.asList(oreNamesIn));
    }

    @Override
    public Item getItemBlock() {
        return this.itemBlock;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (((Boolean)state.func_177229_b((IProperty)field_176466_a)).booleanValue()) {
            state = state.func_177226_a((IProperty)field_176466_a, (Comparable)Boolean.FALSE);
        } else {
            EnumFacing playerFace = EnumFacing.func_176733_a((double)playerIn.field_70177_z);
            if (state.func_177229_b((IProperty)field_185512_D) == playerFace.func_176734_d()) {
                state = state.func_177226_a((IProperty)field_185512_D, (Comparable)playerFace);
            }
            state = state.func_177226_a((IProperty)field_176466_a, (Comparable)Boolean.TRUE);
        }
        worldIn.func_180501_a(pos, state, 10);
        boolean open = (Boolean)state.func_177229_b((IProperty)field_176466_a);
        if (this.field_149764_J == Material.field_151573_f) {
            worldIn.func_184133_a(playerIn, pos, open ? METAL_GATE_OPEN : METAL_GATE_CLOSE, SoundCategory.BLOCKS, 1.0f, 1.0f);
        } else {
            worldIn.func_180498_a(playerIn, open ? 1008 : 1014, pos, 0);
        }
        return true;
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.field_149764_J.func_151565_r();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IStateMapper getStateMapper() {
        return new StateMap.Builder().func_178442_a(new IProperty[]{BlockFenceGate.field_176465_b}).func_178441_a();
    }
}

