/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.util.ArrayList;
import java.util.HashMap;
import org.h2.command.Command;
import org.h2.command.Prepared;
import org.h2.command.dml.CommandWithValues;
import org.h2.command.dml.Query;
import org.h2.command.dml.Update;
import org.h2.engine.GeneratedKeys;
import org.h2.engine.Mode;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.Parameter;
import org.h2.expression.ValueExpression;
import org.h2.expression.condition.Comparison;
import org.h2.expression.condition.ConditionAndOr;
import org.h2.index.BaseIndex;
import org.h2.index.Index;
import org.h2.index.PageDataIndex;
import org.h2.message.DbException;
import org.h2.mvstore.db.MVPrimaryIndex;
import org.h2.result.ResultInterface;
import org.h2.result.ResultTarget;
import org.h2.result.Row;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class Insert
extends CommandWithValues
implements ResultTarget {
    private Table table;
    private Column[] columns;
    private Query query;
    private boolean sortedInsertMode;
    private int rowNumber;
    private boolean insertFromSelect;
    private TableFilter sourceTableFilter;
    private HashMap<Column, Expression> duplicateKeyAssignmentMap;
    private boolean ignore;

    public Insert(Session session) {
        super(session);
    }

    @Override
    public void setCommand(Command command) {
        super.setCommand(command);
        if (this.query != null) {
            this.query.setCommand(command);
        }
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setColumns(Column[] columnArray) {
        this.columns = columnArray;
    }

    public void setIgnore(boolean bl) {
        this.ignore = bl;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public void addAssignmentForDuplicate(Column column, Expression expression) {
        if (this.duplicateKeyAssignmentMap == null) {
            this.duplicateKeyAssignmentMap = new HashMap();
        }
        if (this.duplicateKeyAssignmentMap.containsKey(column)) {
            throw DbException.get(42121, column.getName());
        }
        this.duplicateKeyAssignmentMap.put(column, expression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update() {
        Index index = null;
        if (this.sortedInsertMode) {
            if (!this.session.getDatabase().isMVStore()) {
                this.table.lock(this.session, true, true);
            }
            index = this.table.getScanIndex(this.session);
            index.setSortedInsertMode(true);
        }
        try {
            int n = this.insertRows();
            return n;
        }
        finally {
            if (index != null) {
                index.setSortedInsertMode(false);
            }
        }
    }

    private int insertRows() {
        this.session.getUser().checkRight(this.table, 4);
        this.setCurrentRowNumber(0L);
        this.table.fire(this.session, 1, true);
        this.rowNumber = 0;
        GeneratedKeys generatedKeys = this.session.getGeneratedKeys();
        generatedKeys.initialize(this.table);
        int n = this.valuesExpressionList.size();
        if (n > 0) {
            Mode mode = this.session.getDatabase().getMode();
            int n2 = this.columns.length;
            for (int i = 0; i < n; ++i) {
                int n3;
                generatedKeys.nextRow();
                Row row = this.table.getTemplateRow();
                Expression[] expressionArray = (Expression[])this.valuesExpressionList.get(i);
                this.setCurrentRowNumber(i + 1);
                for (n3 = 0; n3 < n2; ++n3) {
                    Column column = this.columns[n3];
                    int n4 = column.getColumnId();
                    Expression expression = expressionArray[n3];
                    if (expression == null) continue;
                    expression = expression.optimize(this.session);
                    try {
                        Value value = column.convert(expression.getValue(this.session), mode);
                        row.setValue(n4, value);
                        if (!expression.isGeneratedKey()) continue;
                        generatedKeys.add(column);
                        continue;
                    }
                    catch (DbException dbException) {
                        throw this.setRow(dbException, i, Insert.getSimpleSQL(expressionArray));
                    }
                }
                ++this.rowNumber;
                this.table.validateConvertUpdateSequence(this.session, row);
                n3 = this.table.fireBeforeRow(this.session, null, row) ? 1 : 0;
                if (n3 != 0) continue;
                this.table.lock(this.session, true, false);
                try {
                    this.table.addRow(this.session, row);
                }
                catch (DbException dbException) {
                    if (this.handleOnDuplicate(dbException, null)) {
                        ++this.rowNumber;
                        continue;
                    }
                    --this.rowNumber;
                    continue;
                }
                generatedKeys.confirmRow(row);
                this.session.log(this.table, (short)0, row);
                this.table.fireAfterRow(this.session, null, row, false);
            }
        } else {
            this.table.lock(this.session, true, false);
            if (this.insertFromSelect) {
                this.query.query(0, this);
            } else {
                ResultInterface resultInterface = this.query.query(0);
                while (resultInterface.next()) {
                    generatedKeys.nextRow();
                    Value[] valueArray = resultInterface.currentRow();
                    try {
                        Row row = this.addRowImpl(valueArray);
                        if (row == null) continue;
                        generatedKeys.confirmRow(row);
                    }
                    catch (DbException dbException) {
                        if (this.handleOnDuplicate(dbException, valueArray)) {
                            ++this.rowNumber;
                            continue;
                        }
                        --this.rowNumber;
                    }
                }
                resultInterface.close();
            }
        }
        this.table.fire(this.session, 1, false);
        return this.rowNumber;
    }

    @Override
    public void addRow(Value[] valueArray) {
        this.addRowImpl(valueArray);
    }

    private Row addRowImpl(Value[] valueArray) {
        int n;
        Row row = this.table.getTemplateRow();
        this.setCurrentRowNumber(++this.rowNumber);
        Mode mode = this.session.getDatabase().getMode();
        int n2 = this.columns.length;
        for (n = 0; n < n2; ++n) {
            Column column = this.columns[n];
            int n3 = column.getColumnId();
            try {
                Value value = column.convert(valueArray[n], mode);
                row.setValue(n3, value);
                continue;
            }
            catch (DbException dbException) {
                throw this.setRow(dbException, this.rowNumber, Insert.getSQL(valueArray));
            }
        }
        this.table.validateConvertUpdateSequence(this.session, row);
        n = this.table.fireBeforeRow(this.session, null, row) ? 1 : 0;
        if (n == 0) {
            this.table.addRow(this.session, row);
            this.session.log(this.table, (short)0, row);
            this.table.fireAfterRow(this.session, null, row, false);
            return row;
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.rowNumber;
    }

    @Override
    public void limitsWereApplied() {
    }

    @Override
    public String getPlanSQL(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder("INSERT INTO ");
        this.table.getSQL(stringBuilder, bl).append('(');
        Column.writeColumns(stringBuilder, this.columns, bl);
        stringBuilder.append(")\n");
        if (this.insertFromSelect) {
            stringBuilder.append("DIRECT ");
        }
        if (this.sortedInsertMode) {
            stringBuilder.append("SORTED ");
        }
        if (!this.valuesExpressionList.isEmpty()) {
            stringBuilder.append("VALUES ");
            int n = 0;
            if (this.valuesExpressionList.size() > 1) {
                stringBuilder.append('\n');
            }
            for (Expression[] expressionArray : this.valuesExpressionList) {
                if (n++ > 0) {
                    stringBuilder.append(",\n");
                }
                stringBuilder.append('(');
                Expression.writeExpressions(stringBuilder, expressionArray, bl);
                stringBuilder.append(')');
            }
        } else {
            stringBuilder.append(this.query.getPlanSQL(bl));
        }
        return stringBuilder.toString();
    }

    @Override
    public void prepare() {
        if (this.columns == null) {
            this.columns = !this.valuesExpressionList.isEmpty() && ((Expression[])this.valuesExpressionList.get(0)).length == 0 ? new Column[0] : this.table.getColumns();
        }
        if (!this.valuesExpressionList.isEmpty()) {
            for (Expression[] expressionArray : this.valuesExpressionList) {
                if (expressionArray.length != this.columns.length) {
                    throw DbException.get(21002);
                }
                int n = expressionArray.length;
                for (int i = 0; i < n; ++i) {
                    Expression expression = expressionArray[i];
                    if (expression == null) continue;
                    if (this.sourceTableFilter != null) {
                        expression.mapColumns(this.sourceTableFilter, 0, 0);
                    }
                    if ((expression = expression.optimize(this.session)) instanceof Parameter) {
                        Parameter parameter = (Parameter)expression;
                        parameter.setColumn(this.columns[i]);
                    }
                    expressionArray[i] = expression;
                }
            }
        } else {
            this.query.prepare();
            if (this.query.getColumnCount() != this.columns.length) {
                throw DbException.get(21002);
            }
        }
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    public void setSortedInsertMode(boolean bl) {
        this.sortedInsertMode = bl;
    }

    @Override
    public int getType() {
        return 61;
    }

    public void setInsertFromSelect(boolean bl) {
        this.insertFromSelect = bl;
    }

    @Override
    public boolean isCacheable() {
        return this.duplicateKeyAssignmentMap == null || this.duplicateKeyAssignmentMap.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private boolean handleOnDuplicate(DbException dbException, Value[] valueArray) {
        Object object;
        Object object3;
        if (dbException.getErrorCode() != 23505) {
            throw dbException;
        }
        if (this.duplicateKeyAssignmentMap == null || this.duplicateKeyAssignmentMap.isEmpty()) {
            if (this.ignore) {
                return false;
            }
            throw dbException;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(this.duplicateKeyAssignmentMap.size());
        Expression[] expressionArray = valueArray == null ? (Expression[])this.valuesExpressionList.get((int)this.getCurrentRowNumber() - 1) : new Expression[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            void object22;
            StringBuilder stringBuilder = this.table.getSQL(new StringBuilder(), true).append('.');
            object3 = this.columns[i].getSQL(stringBuilder, true).toString();
            arrayList.add(object3);
            if (valueArray != null) {
                Value value = valueArray[i];
                expressionArray[i] = ValueExpression.get(value);
            } else {
                Value value = expressionArray[i].getValue(this.session);
            }
            this.session.setVariable((String)object3, (Value)object22);
        }
        StringBuilder stringBuilder = new StringBuilder("UPDATE ");
        this.table.getSQL(stringBuilder, true).append(" SET ");
        boolean bl = false;
        for (Column column : this.duplicateKeyAssignmentMap.keySet()) {
            if (bl) {
                stringBuilder.append(", ");
            }
            bl = true;
            object = this.duplicateKeyAssignmentMap.get(column);
            column.getSQL(stringBuilder, true).append('=');
            ((Expression)object).getSQL(stringBuilder, true);
        }
        stringBuilder.append(" WHERE ");
        object3 = (Index)dbException.getSource();
        if (object3 == null) {
            throw DbException.getUnsupportedException("Unable to apply ON DUPLICATE KEY UPDATE, no index found!");
        }
        this.prepareUpdateCondition((Index)object3, expressionArray).getSQL(stringBuilder, true);
        String string = stringBuilder.toString();
        object = (Update)this.session.prepare(string);
        ((Update)object).setUpdateToCurrentValuesReturnsZero(true);
        for (Parameter parameter : ((Prepared)object).getParameters()) {
            Object object2 = (Parameter)this.parameters.get(parameter.getIndex());
            parameter.setValue(((Parameter)object2).getValue(this.session));
        }
        boolean bl2 = ((Update)object).update() > 0;
        for (Object object2 : arrayList) {
            this.session.setVariable((String)object2, ValueNull.INSTANCE);
        }
        return bl2;
    }

    private Expression prepareUpdateCondition(Index index, Expression[] expressionArray) {
        Column[] columnArray;
        Object object;
        if (index instanceof MVPrimaryIndex) {
            object = (MVPrimaryIndex)index;
            columnArray = new Column[]{((BaseIndex)object).getIndexColumns()[((MVPrimaryIndex)object).getMainIndexColumn()].column};
        } else if (index instanceof PageDataIndex) {
            Column[] columnArray2;
            object = (PageDataIndex)index;
            int n = ((PageDataIndex)object).getMainIndexColumn();
            if (n >= 0) {
                Column[] columnArray3 = new Column[1];
                columnArray2 = columnArray3;
                columnArray3[0] = ((BaseIndex)object).getIndexColumns()[n].column;
            } else {
                columnArray2 = index.getColumns();
            }
            columnArray = columnArray2;
        } else {
            columnArray = index.getColumns();
        }
        object = null;
        block0: for (Column column : columnArray) {
            ExpressionColumn expressionColumn = new ExpressionColumn(this.session.getDatabase(), this.table.getSchema().getName(), this.table.getName(), column.getName(), false);
            for (int i = 0; i < this.columns.length; ++i) {
                if (!expressionColumn.getColumnName().equals(this.columns[i].getName())) continue;
                if (object == null) {
                    object = new Comparison(this.session, 0, expressionColumn, expressionArray[i]);
                    continue block0;
                }
                object = new ConditionAndOr(0, (Expression)object, new Comparison(this.session, 0, expressionColumn, expressionArray[i]));
                continue block0;
            }
        }
        return object;
    }

    public void setSourceTableFilter(TableFilter tableFilter) {
        this.sourceTableFilter = tableFilter;
    }
}

