/*
 * Decompiled with CFR 0.152.
 */
package ic2.api.classic.trading.prefab;

import ic2.api.classic.trading.ITradeInventory;
import ic2.api.classic.trading.prefab.BasicSubTrade;
import ic2.api.classic.trading.providers.IItemTradeProvider;
import ic2.api.classic.trading.providers.ITradeProvider;
import ic2.api.classic.trading.trades.IItemTrade;
import ic2.api.classic.trading.trades.ISubTrade;
import ic2.api.classic.trading.trades.ITrade;
import ic2.api.classic.trading.trades.TradeType;
import ic2.core.item.recipe.entry.RecipeInputItemStack;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;

public class BasicItemTrade
implements IItemTrade {
    ItemStack required;
    ItemStack gain;
    ISubTrade subTrade;

    public BasicItemTrade() {
    }

    public BasicItemTrade(ItemStack wanted, ItemStack give) {
        this.required = wanted.func_77946_l();
        this.gain = give.func_77946_l();
        this.subTrade = new BasicSubTrade(this, wanted);
    }

    @Override
    public boolean canAccessTrade(UUID player) {
        return true;
    }

    @Override
    public TradeType getType() {
        return TradeType.Item;
    }

    @Override
    public List<ISubTrade> getSubTrades(UUID player, boolean ignoreOwner) {
        return Arrays.asList(this.subTrade);
    }

    @Override
    public ISubTrade getSubTradeFromSlot(int slot, UUID player, boolean ignoreOwner) {
        return slot == 0 ? this.subTrade : null;
    }

    @Override
    public int getTradeSlot(ISubTrade sub) {
        return this.subTrade.equals(sub) ? 0 : -1;
    }

    @Override
    public ActionResult<List<ItemStack>> trade(UUID player, ITradeProvider prov, ISubTrade trade, ITradeInventory inv, int limit) {
        if (!this.subTrade.equals(trade) || !(prov instanceof IItemTradeProvider)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)EMPTY_LIST);
        }
        RecipeInputItemStack input = new RecipeInputItemStack(this.required);
        int total = inv.getItemCount(input);
        int count = Math.min(limit, total / this.required.func_190916_E());
        if (count <= 0) {
            return new ActionResult(EnumActionResult.PASS, (Object)EMPTY_LIST);
        }
        List<ItemStack> list = ((IItemTradeProvider)prov).getNearbyItemStack(new RecipeInputItemStack(this.gain), this.gain.func_190916_E() * count, true);
        if (list.isEmpty()) {
            return new ActionResult(EnumActionResult.PASS, (Object)EMPTY_LIST);
        }
        float multiplier = (float)this.getTotalStackSize(list) / (float)this.gain.func_190916_E();
        if (multiplier <= 0.0f) {
            return new ActionResult(EnumActionResult.PASS, (Object)EMPTY_LIST);
        }
        ((IItemTradeProvider)prov).getNearbyItemStack(new RecipeInputItemStack(this.gain), this.gain.func_190916_E() * count, false);
        List<ItemStack> removed = inv.removeItems(input, Math.min(total, (int)((float)this.required.func_190916_E() * multiplier)));
        prov.onTradePerformed(player, trade, removed);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, list);
    }

    public int getTotalStackSize(List<ItemStack> list) {
        int total = 0;
        for (ItemStack stack : list) {
            total += stack.func_190916_E();
        }
        return total;
    }

    @Override
    public List<ItemStack> getTradeResults(ISubTrade sub) {
        return Arrays.asList(this.gain.func_77946_l());
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) throws Exception {
        this.required = new ItemStack(nbt.func_74775_l("wanted"));
        this.gain = new ItemStack(nbt.func_74775_l("give"));
        if (this.gain.func_190926_b() || this.required.func_190926_b()) {
            throw new Exception("Items got removed. Trade is now invalid");
        }
        this.subTrade = new BasicSubTrade(this, this.required);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound data = new NBTTagCompound();
        this.required.func_77955_b(data);
        nbt.func_74782_a("wanted", (NBTBase)data);
        data = new NBTTagCompound();
        this.gain.func_77955_b(data);
        nbt.func_74782_a("give", (NBTBase)data);
    }

    @Override
    public ITrade<ItemStack> newInstance(UUID owner) {
        return new BasicItemTrade(this.required, this.gain);
    }

    @Override
    public int getStockCount(ISubTrade sub, ITradeProvider prov, UUID player) {
        if (!this.subTrade.equals(sub) || !(prov instanceof IItemTradeProvider)) {
            return 0;
        }
        List<ItemStack> count = ((IItemTradeProvider)prov).getNearbyItemStack(new RecipeInputItemStack(this.gain), this.gain.func_190916_E() * Short.MAX_VALUE, false);
        return this.getTotalStackSize(count) / this.gain.func_190916_E();
    }
}

