/*
 * Decompiled with CFR 0.152.
 */
package ic2.core;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public final class RotationList
implements Iterable<EnumFacing>,
Predicate<EnumFacing> {
    static final Random RAND = new Random();
    static final RotationList[] ROTATIONS = RotationList.generateArray();
    public static final RotationList DOWN = RotationList.ofFacing(EnumFacing.DOWN);
    public static final RotationList UP = RotationList.ofFacing(EnumFacing.UP);
    public static final RotationList NORTH = RotationList.ofFacing(EnumFacing.NORTH);
    public static final RotationList SOUTH = RotationList.ofFacing(EnumFacing.SOUTH);
    public static final RotationList EAST = RotationList.ofFacing(EnumFacing.EAST);
    public static final RotationList WEST = RotationList.ofFacing(EnumFacing.WEST);
    public static final RotationList VERTICAL = DOWN.add(UP);
    public static final RotationList HORIZONTAL = RotationList.ofFacings(EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST);
    public static final RotationList X_AXIS = EAST.add(WEST);
    public static final RotationList Z_AXIS = NORTH.add(SOUTH);
    public static final RotationList XY_AXIS = X_AXIS.add(VERTICAL);
    public static final RotationList YZ_AXIS = Z_AXIS.add(VERTICAL);
    public static final RotationList P_CORNER = SOUTH.add(EAST);
    public static final RotationList N_CORNER = NORTH.add(WEST);
    public static final RotationList ALL = RotationList.ofNumber(63);
    public static final RotationList EMPTY = RotationList.ofNumber(0);
    final int code;
    final int size;
    BlockPos offset;
    EnumFacing[] array;
    Map<EnumFacing, EnumFacing> forwardHelper;
    Map<EnumFacing, EnumFacing> backwardHelper;

    private RotationList() {
        throw new RuntimeException("NOT ALLOWED!");
    }

    private RotationList(int index) {
        this.code = (byte)MathHelper.func_76125_a((int)index, (int)0, (int)63);
        BlockPos.MutableBlockPos helper = new BlockPos.MutableBlockPos();
        ObjectArrayList list = new ObjectArrayList();
        for (int i = 0; i < 6; ++i) {
            if ((this.code & 1 << i) == 0) continue;
            EnumFacing dir = EnumFacing.func_82600_a((int)i);
            helper.func_189536_c(dir);
            list.add((Object)dir);
        }
        this.offset = helper.func_185334_h();
        this.size = list.size();
        this.array = (EnumFacing[])list.toArray((Object[])new EnumFacing[this.size]);
        if (this.size == 0) {
            this.forwardHelper = ImmutableMap.of();
            return;
        }
        Object2ObjectLinkedOpenHashMap forward = new Object2ObjectLinkedOpenHashMap();
        Object2ObjectLinkedOpenHashMap backward = new Object2ObjectLinkedOpenHashMap();
        for (int i = 0; i < this.array.length; ++i) {
            forward.put(this.array[i], this.array[(i + 1) % this.array.length]);
            backward.put(this.array[(i + 1) % this.array.length], this.array[i]);
        }
        this.forwardHelper = ImmutableMap.copyOf((Map)forward);
        this.backwardHelper = ImmutableMap.copyOf((Map)backward);
    }

    public static RotationList ofFacing(EnumFacing facing) {
        return ROTATIONS[1 << facing.func_176745_a()];
    }

    public static RotationList ofFacings(EnumFacing ... facings) {
        return ROTATIONS[RotationList.toNumber(facings)];
    }

    public static RotationList ofFacings(Collection<EnumFacing> facings) {
        return ROTATIONS[RotationList.toNumber(facings)];
    }

    public static RotationList ofAxis(EnumFacing.Axis axis) {
        int value = 0;
        for (EnumFacing dir : ALL) {
            if (!axis.test((Object)dir)) continue;
            value |= 1 << dir.func_176745_a();
        }
        return ROTATIONS[value];
    }

    public static RotationList ofFlags(boolean ... flags) {
        return ROTATIONS[RotationList.toNumber(flags)];
    }

    public static RotationList ofNumber(int index) {
        return ROTATIONS[MathHelper.func_76125_a((int)index, (int)0, (int)63)];
    }

    public RotationList rotate(int amount) {
        int value = 0;
        for (int i = 0; i < 6; ++i) {
            if ((this.code & 1 << i) == 0) continue;
            value |= 1 << EnumFacing.func_82600_a((int)(i + amount)).func_176745_a();
        }
        return ROTATIONS[value & 0x3F];
    }

    public RotationList invert() {
        return ROTATIONS[63 - this.code];
    }

    public RotationList opposite() {
        int value = 0;
        for (int i = 0; i < 6; ++i) {
            if ((this.code & 1 << i) == 0) continue;
            value |= 1 << EnumFacing.func_82600_a((int)i).func_176734_d().func_176745_a();
        }
        return ROTATIONS[value & 0x3F];
    }

    public RotationList add(EnumFacing facing) {
        return ROTATIONS[this.code | 1 << facing.func_176745_a()];
    }

    public RotationList add(RotationList facings) {
        return ROTATIONS[this.code | facings.code];
    }

    public RotationList remove(EnumFacing facing) {
        return ROTATIONS[this.code & ~(1 << facing.func_176745_a())];
    }

    public RotationList remove(RotationList facings) {
        return ROTATIONS[this.code & ~facings.code];
    }

    public boolean contains(EnumFacing EnumFacing2) {
        return (this.code & 1 << EnumFacing2.func_176745_a()) != 0;
    }

    public boolean contains(RotationList facings) {
        return (this.code & facings.code) == facings.code;
    }

    public boolean containsAny(RotationList facings) {
        return (this.code & facings.code) != 0;
    }

    public boolean notContains(EnumFacing EnumFacing2) {
        return (this.code & 1 << EnumFacing2.func_176745_a()) == 0;
    }

    public boolean containsNot(RotationList facings) {
        return (this.code & facings.code) == 0;
    }

    public RotationList invertFacing(EnumFacing facing) {
        if (this.contains(facing)) {
            return this.remove(facing).add(facing.func_176734_d());
        }
        return this;
    }

    public EnumFacing getNextFacing(EnumFacing facing) {
        if (this.contains(facing)) {
            return this.forwardHelper.get(facing);
        }
        return this.code == 0 ? facing : this.array[0];
    }

    public EnumFacing getPrevFacing(EnumFacing facing) {
        if (this.contains(facing)) {
            return this.backwardHelper.get(facing);
        }
        return this.code == 0 ? facing : this.array[this.array.length - 1];
    }

    public BlockPos getOffset() {
        return this.offset;
    }

    public int getCode() {
        return this.code;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.code == 0;
    }

    public boolean isFull() {
        return this.code == 63;
    }

    public String toString() {
        return ObjectArrayList.wrap((Object[])this.array).toString();
    }

    public Set<EnumFacing> toFacings() {
        return this.code == 0 ? EnumSet.noneOf(EnumFacing.class) : EnumSet.copyOf(ObjectArrayList.wrap((Object[])this.array));
    }

    public EnumFacing getRandomFacing() {
        return this.getRandomFacing(EnumFacing.NORTH);
    }

    public EnumFacing getRandomFacing(EnumFacing defaultValue) {
        return this.code == 0 ? defaultValue : this.array[RAND.nextInt(this.size)];
    }

    public boolean[] toFlags() {
        boolean[] flags = new boolean[6];
        for (int i = 0; i < 6; ++i) {
            if ((this.code & 1 << i) == 0) continue;
            flags[i] = true;
        }
        return flags;
    }

    public static IBlockState getNeighborState(TileEntity tile, EnumFacing dir) {
        return RotationList.getNeighborState(tile.func_145831_w(), tile.func_174877_v(), dir);
    }

    public static IBlockState getNeighborState(World world, BlockPos pos, EnumFacing dir) {
        return world.func_175667_e(pos = pos.func_177972_a(dir)) ? world.func_180495_p(pos) : Blocks.field_150350_a.func_176223_P();
    }

    public static TileEntity getNeighborTile(TileEntity tile, EnumFacing dir) {
        return RotationList.getNeighborTile(tile.func_145831_w(), tile.func_174877_v(), dir);
    }

    public static TileEntity getNeighborTile(World world, BlockPos pos, EnumFacing dir) {
        return world.func_175667_e(pos = pos.func_177972_a(dir)) ? world.func_175625_s(pos) : null;
    }

    public static int toNumber(EnumFacing ... facings) {
        int value = 0;
        for (EnumFacing facing : facings) {
            value |= 1 << facing.func_176745_a();
        }
        return value & 0x3F;
    }

    public static int toNumber(Collection<EnumFacing> facings) {
        int value = 0;
        for (EnumFacing facing : facings) {
            value |= 1 << facing.func_176745_a();
        }
        return value & 0x3F;
    }

    public static int toNumber(boolean ... facings) {
        return (facings[0] ? 1 : 0) << 0 | (facings[1] ? 1 : 0) << 1 | (facings[2] ? 1 : 0) << 2 | (facings[3] ? 1 : 0) << 3 | (facings[4] ? 1 : 0) << 4 | (facings[5] ? 1 : 0) << 5;
    }

    public static boolean[] toFlags(EnumFacing ... facings) {
        boolean[] array = new boolean[6];
        for (EnumFacing face : facings) {
            array[face.func_176745_a()] = true;
        }
        return array;
    }

    @Override
    public boolean test(EnumFacing t) {
        return this.contains(t);
    }

    @Override
    public Iterator<EnumFacing> iterator() {
        return new Iterator<EnumFacing>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < RotationList.this.size;
            }

            @Override
            public EnumFacing next() {
                return RotationList.this.array[this.index++];
            }
        };
    }

    public Iterable<EnumFacing> getRandomIterator() {
        return new Iterable<EnumFacing>(){

            @Override
            public Iterator<EnumFacing> iterator() {
                return new Iterator<EnumFacing>(){
                    EnumFacing[] data;
                    int index;
                    {
                        this.data = (EnumFacing[])ObjectArrays.shuffle((Object[])ObjectArrays.copy((Object[])RotationList.this.array), (Random)RAND);
                        this.index = 0;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index < this.data.length;
                    }

                    @Override
                    public EnumFacing next() {
                        return this.data[this.index++];
                    }
                };
            }
        };
    }

    static RotationList[] generateArray() {
        RotationList[] rotations = new RotationList[64];
        for (int i = 0; i < 64; ++i) {
            rotations[i] = new RotationList(i);
        }
        return rotations;
    }
}

