/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator;

import ic2.core.IC2;
import ic2.core.block.base.BlockMultiID;
import ic2.core.block.base.tile.TileEntityBlock;
import ic2.core.block.generator.tile.TileEntityBasicSteamTurbine;
import ic2.core.block.generator.tile.TileEntityFuelBoiler;
import ic2.core.block.generator.tile.TileEntityGenerator;
import ic2.core.block.generator.tile.TileEntityGeoGenerator;
import ic2.core.block.generator.tile.TileEntityLiquidFuelGenerator;
import ic2.core.block.generator.tile.TileEntityNuclearReactorElectric;
import ic2.core.block.generator.tile.TileEntityNuclearSteamReactor;
import ic2.core.block.generator.tile.TileEntityOceanGenerator;
import ic2.core.block.generator.tile.TileEntitySlagGenerator;
import ic2.core.block.generator.tile.TileEntitySolarPanel;
import ic2.core.block.generator.tile.TileEntitySolarTurbine;
import ic2.core.block.generator.tile.TileEntityThermalGenerator;
import ic2.core.block.generator.tile.TileEntityWaterGenerator;
import ic2.core.block.generator.tile.TileEntityWaveGenerator;
import ic2.core.block.generator.tile.TileEntityWindGenerator;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2States;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.platform.textures.obj.ILayeredBlockModel;
import ic2.core.util.helpers.BlockStateContainerIC2;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.IBootable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGenerator
extends BlockMultiID
implements IBootable,
ILayeredBlockModel {
    public BlockGenerator() {
        super(Material.field_151573_f);
        this.func_149711_c(5.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.setUnlocalizedName(Ic2BlockLang.generator);
        this.setHarvestLevel("pickaxe", 1);
    }

    @Override
    public TileEntityBlock createNewTileEntity(World worldIn, int meta) {
        switch (meta) {
            case 0: {
                return new TileEntityGenerator();
            }
            case 1: {
                return new TileEntityGeoGenerator();
            }
            case 2: {
                return new TileEntityWaterGenerator();
            }
            case 3: {
                return new TileEntitySolarPanel();
            }
            case 4: {
                return new TileEntityWindGenerator();
            }
            case 5: {
                return new TileEntityNuclearReactorElectric();
            }
            case 6: {
                return new TileEntityNuclearSteamReactor();
            }
            case 7: {
                return new TileEntityBasicSteamTurbine();
            }
            case 8: {
                return new TileEntityThermalGenerator();
            }
            case 9: {
                return new TileEntitySolarTurbine();
            }
            case 10: {
                return new TileEntityLiquidFuelGenerator();
            }
            case 11: {
                return new TileEntitySlagGenerator();
            }
            case 12: {
                return new TileEntityWaveGenerator();
            }
            case 13: {
                return new TileEntityOceanGenerator();
            }
            case 14: {
                return new TileEntityFuelBoiler();
            }
        }
        return null;
    }

    @Override
    public void onLoad() {
        Ic2States.generator = this.func_176203_a(0);
        Ic2States.geothermalGenerator = this.func_176203_a(1);
        Ic2States.waterMill = this.func_176203_a(2);
        Ic2States.solarPanel = this.func_176203_a(3);
        Ic2States.windMill = this.func_176203_a(4);
        Ic2States.nuclearReactor = this.func_176203_a(5);
        Ic2States.steamReactor = this.func_176203_a(6);
        Ic2States.basicTurbine = this.func_176203_a(7);
        Ic2States.thermalGenerator = this.func_176203_a(8);
        Ic2States.solarTurbine = this.func_176203_a(9);
        Ic2States.liquidFuelGenerator = this.func_176203_a(10);
        Ic2States.slagGenerator = this.func_176203_a(11);
        Ic2States.waveGenerator = this.func_176203_a(12);
        Ic2States.oceanGenerator = this.func_176203_a(13);
        Ic2States.boiler = this.func_176203_a(14);
        Ic2Items.generator = new ItemStack((Block)this, 1, 0);
        Ic2Items.geothermalGenerator = new ItemStack((Block)this, 1, 1);
        Ic2Items.waterMill = new ItemStack((Block)this, 1, 2);
        Ic2Items.solarPanel = new ItemStack((Block)this, 1, 3);
        Ic2Items.windMill = new ItemStack((Block)this, 1, 4);
        Ic2Items.nuclearReactor = new ItemStack((Block)this, 1, 5);
        Ic2Items.steamReactor = new ItemStack((Block)this, 1, 6);
        Ic2Items.basicTurbine = new ItemStack((Block)this, 1, 7);
        Ic2Items.thermalGenerator = new ItemStack((Block)this, 1, 8);
        Ic2Items.solarTurbine = new ItemStack((Block)this, 1, 9);
        Ic2Items.liquidFuelGenerator = new ItemStack((Block)this, 1, 10);
        Ic2Items.slagGenerator = new ItemStack((Block)this, 1, 11);
        Ic2Items.waveGenerator = new ItemStack((Block)this, 1, 12);
        Ic2Items.oceanGenerator = new ItemStack((Block)this, 1, 13);
        Ic2Items.boiler = new ItemStack((Block)this, 1, 14);
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this.func_176201_c(state) == 5 && StackUtil.isStackEqual(playerIn.func_184586_b(hand), Ic2Items.reactorChamber)) {
            return false;
        }
        if (this.func_176201_c(state) == 6 && StackUtil.isStackEqual(playerIn.func_184586_b(hand), Ic2Items.steamReactorChamber)) {
            return false;
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    @Override
    public List<IBlockState> getValidStates() {
        return this.func_176194_O().func_177619_a();
    }

    @Override
    public List<IBlockState> getValidStateList() {
        IBlockState def = this.func_176223_P();
        ArrayList<IBlockState> states = new ArrayList<IBlockState>();
        int[] array = new int[]{0, 1, 2, 3, 4, 7, 8, 9, 10, 11, 12, 13, 14};
        for (int i = 0; i < array.length; ++i) {
            int meta = array[i];
            for (EnumFacing side : EnumFacing.field_82609_l) {
                states.add(def.func_177226_a((IProperty)this.getMetadataProperty(), (Comparable)Integer.valueOf(meta)).func_177226_a((IProperty)allFacings, (Comparable)side).func_177226_a((IProperty)active, (Comparable)Boolean.valueOf(false)));
                states.add(def.func_177226_a((IProperty)this.getMetadataProperty(), (Comparable)Integer.valueOf(meta)).func_177226_a((IProperty)allFacings, (Comparable)side).func_177226_a((IProperty)active, (Comparable)Boolean.valueOf(true)));
            }
        }
        states.add(def.func_177226_a((IProperty)this.getMetadataProperty(), (Comparable)Integer.valueOf(5)).func_177226_a((IProperty)active, (Comparable)Boolean.valueOf(false)));
        states.add(def.func_177226_a((IProperty)this.getMetadataProperty(), (Comparable)Integer.valueOf(5)).func_177226_a((IProperty)active, (Comparable)Boolean.valueOf(true)));
        states.add(def.func_177226_a((IProperty)this.getMetadataProperty(), (Comparable)Integer.valueOf(6)).func_177226_a((IProperty)active, (Comparable)Boolean.valueOf(false)));
        states.add(def.func_177226_a((IProperty)this.getMetadataProperty(), (Comparable)Integer.valueOf(6)).func_177226_a((IProperty)active, (Comparable)Boolean.valueOf(true)));
        return states;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile;
        if (this.func_176201_c(state) == 8 && (tile = world.func_175625_s(pos)) instanceof TileEntityThermalGenerator && ((TileEntityThermalGenerator)tile).fuel > 0) {
            return new BlockStateContainerIC2.IC2BlockState(state, 1);
        }
        return super.getExtendedState(state, world, pos);
    }

    @Override
    public List<Integer> getValidMetas() {
        return Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite[] getIconSheet(int meta) {
        return Ic2Icons.getTextures("bgen");
    }

    public int func_180651_a(IBlockState state) {
        int meta = this.func_176201_c(state);
        return meta == 2 ? 2 : 0;
    }

    @Override
    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (placer instanceof EntityPlayer) {
            String id = this.getID(this.func_176201_c(state), false);
            if (id == null) {
                return;
            }
            IC2.achievements.issueStat((EntityPlayer)placer, id);
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        String id = this.getID(this.func_176201_c(world.func_180495_p(pos)), true);
        if (id != null) {
            IC2.achievements.issueStat(player, id);
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    @Override
    public List<ItemStack> getWrenchDrops(World world, BlockPos pos, IBlockState state, TileEntity te, EntityPlayer player, int fortune) {
        String id = this.getID(this.func_176201_c(state), true);
        if (id != null) {
            IC2.achievements.issueStat(player, id);
        }
        return super.getWrenchDrops(world, pos, state, te, player, fortune);
    }

    public String getID(int meta, boolean opposite) {
        switch (meta) {
            case 0: {
                return opposite ? "cleanEnergy" : "dirtyEnergy";
            }
            case 1: {
                return opposite ? "cleanEnergy" : "dirtyEnergy";
            }
            case 2: {
                return opposite ? "dirtyEnergy" : "cleanEnergy";
            }
            case 3: {
                return opposite ? "dirtyEnergy" : "cleanEnergy";
            }
            case 4: {
                return opposite ? "dirtyEnergy" : "cleanEnergy";
            }
            case 5: {
                return opposite ? "cleanEnergy" : "dirtyEnergy";
            }
            case 6: {
                return opposite ? "cleanEnergy" : "dirtyEnergy";
            }
            case 7: {
                return opposite ? "dirtyEnergy" : "cleanEnergy";
            }
            case 8: {
                return opposite ? "dirtyEnergy" : "cleanEnergy";
            }
            case 9: {
                return opposite ? "dirtyEnergy" : "cleanEnergy";
            }
            case 10: {
                return opposite ? "cleanEnergy" : "dirtyEnergy";
            }
            case 11: {
                return opposite ? "cleanEnergy" : "dirtyEnergy";
            }
            case 12: {
                return opposite ? "dirtyEnergy" : "cleanEnergy";
            }
            case 13: {
                return opposite ? "dirtyEnergy" : "cleanEnergy";
            }
            case 14: {
                return opposite ? "cleanEnergy" : "dirtyEnergy";
            }
        }
        return null;
    }

    @Override
    public int getMaxSheetSize(int meta) {
        return 17;
    }

    @Override
    public boolean isLayered(IBlockState state) {
        return this.func_176201_c(state) == 8 && (Boolean)state.func_177229_b((IProperty)active) != false;
    }

    @Override
    public int getLayers(IBlockState state) {
        return 2;
    }

    @Override
    public AxisAlignedBB getRenderBox(IBlockState state, int layer) {
        return field_185505_j;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getLayerTexture(IBlockState state, EnumFacing side, int layer) {
        if (layer == 0) {
            return this.getTextureFromState(state, side);
        }
        return this.getTextureFromState(state.func_177226_a((IProperty)active, (Comparable)Boolean.valueOf(false)), this.func_176201_c(state), 16, side);
    }

    @Deprecated
    public boolean func_189872_a(IBlockState state, Entity entityIn) {
        int meta = this.func_176201_c(state);
        if (meta == 3 || meta == 9) {
            return false;
        }
        return super.func_189872_a(state, entityIn);
    }

    @Override
    public boolean needsRedstoneUpdates(int meta) {
        return meta == 5 || meta == 6;
    }
}

