/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.slots;

import ic2.core.block.personal.base.trades.builder.FluidInventory;
import ic2.core.inventory.slots.SlotGhoest;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class SlotFluidDisplay
extends SlotGhoest {
    public SlotFluidDisplay(FluidInventory inv, int index, int xPosition, int yPosition) {
        super(inv, index, xPosition, yPosition);
    }

    @Override
    public void onClick(int mouseButton, boolean half, ItemStack itemStack) {
        FluidStack invFluid;
        if (this.locked) {
            return;
        }
        FluidInventory inv = this.getInv();
        if (mouseButton == 2) {
            inv.setFluid(this.slot, null);
            return;
        }
        FluidStack fluid = this.getFluid(itemStack);
        if (mouseButton == 0) {
            if (!inv.hasFluid(this.slot)) {
                if (fluid != null) {
                    inv.setFluid(this.slot, fluid);
                }
                return;
            }
            invFluid = inv.getFluid(this.slot);
            if (fluid == null) {
                invFluid.amount = invFluid.amount - (half ? 100 : 1000);
                if (invFluid.amount <= 0) {
                    inv.setFluid(this.slot, null);
                    return;
                }
                inv.updateSlot(this.slot);
            } else if (fluid.isFluidEqual(invFluid)) {
                invFluid.amount = half ? (invFluid.amount -= fluid.amount / 2) : (invFluid.amount -= fluid.amount);
                if (invFluid.amount <= 0) {
                    inv.setFluid(this.slot, null);
                    return;
                }
                inv.updateSlot(this.slot);
            }
        }
        if (mouseButton == 1) {
            if (!inv.hasFluid(this.slot)) {
                if (fluid != null) {
                    inv.setFluid(this.slot, fluid);
                }
                return;
            }
            invFluid = inv.getFluid(this.slot);
            if (fluid == null) {
                invFluid.amount = invFluid.amount + (half ? 100 : 1000);
                inv.updateSlot(this.slot);
            } else if (fluid.isFluidEqual(invFluid)) {
                invFluid.amount = half ? (invFluid.amount += fluid.amount / 2) : (invFluid.amount += fluid.amount);
                inv.updateSlot(this.slot);
            }
        }
    }

    private FluidStack getFluid(ItemStack itemStack) {
        return FluidUtil.getFluidContained((ItemStack)itemStack);
    }

    public FluidInventory getInv() {
        return (FluidInventory)this.field_75224_c;
    }

    public void putFluid(FluidStack fluid) {
        this.getInv().setFluid(this.slot, fluid);
    }
}

