/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.base;

import ic2.api.classic.item.IDamagelessElectricItem;
import ic2.api.classic.item.IElectricTool;
import ic2.api.item.ElectricItem;
import ic2.core.platform.lang.components.base.LangComponentHolder;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.platform.textures.obj.ICustomItemCameraTransform;
import ic2.core.util.helpers.ToolHelper;
import ic2.core.util.obj.ToolTipType;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemElectricTool
extends ItemTool
implements IDamagelessElectricItem,
IElectricTool,
ICustomItemCameraTransform {
    public LocaleComp name;
    public int operationEnergyCost;
    public int maxCharge;
    public int transferLimit;
    public int tier;

    public ItemElectricTool(float par1, float par2, Item.ToolMaterial material) {
        super(par1, par2, material, new HashSet());
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.setNoRepair();
        this.name = Ic2Lang.nullKey;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        EnumMap<ToolTipType, List<String>> dataMap = new EnumMap<ToolTipType, List<String>>(ToolTipType.class);
        dataMap.put(ToolTipType.Ctrl, new LinkedList());
        dataMap.put(ToolTipType.Shift, new LinkedList());
        dataMap.put(ToolTipType.Alt, new LinkedList());
        this.onSortedItemToolTip(stack, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, flagIn.func_194127_a(), tooltip, dataMap);
        for (ToolTipType type : new ToolTipType[]{ToolTipType.Alt, ToolTipType.Shift, ToolTipType.Ctrl}) {
            List text = (List)dataMap.get((Object)type);
            if (text.size() <= 0) continue;
            if (type.isKeyDown()) {
                text.add("");
                tooltip.addAll(1, text);
                continue;
            }
            tooltip.add(1, type.getTypeInfo());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    @Override
    public double getMaxCharge(ItemStack stack) {
        return this.maxCharge;
    }

    @Override
    public int getTier(ItemStack stack) {
        return this.tier;
    }

    @Override
    public double getTransferLimit(ItemStack stack) {
        return this.transferLimit;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (!ElectricItem.manager.canUse(stack, this.getEnergyCost(stack))) {
            return 1.0f;
        }
        if (ToolHelper.isToolEffective(state, stack)) {
            return this.getMiningSpeed(stack);
        }
        if (this.canHarvestBlock(state, stack)) {
            return this.getMiningSpeed(stack);
        }
        return super.func_150893_a(stack, state);
    }

    public float getMiningSpeed(ItemStack stack) {
        return this.field_77864_a;
    }

    public int getEnergyCost(ItemStack stack) {
        return this.operationEnergyCost;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState blockIn, BlockPos pos, EntityLivingBase entityLiving) {
        if ((double)blockIn.func_185887_b(worldIn, pos) != 0.0) {
            ElectricItem.manager.use(stack, this.getEnergyCost(stack), entityLiving);
        }
        return true;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean isRepairable() {
        return false;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        ItemStack empty = new ItemStack((Item)this, 1, 0);
        ItemStack full = new ItemStack((Item)this, 1, 0);
        ElectricItem.manager.discharge(empty, 2.147483647E9, Integer.MAX_VALUE, true, false, false);
        ElectricItem.manager.charge(full, 2.147483647E9, Integer.MAX_VALUE, true, false);
        items.add((Object)empty);
        items.add((Object)full);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ElectricItem.manager.getCharge(stack) / this.getMaxCharge(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    @Override
    public boolean isExcluded(ItemStack item, Enchantment ench) {
        return ench == Enchantments.field_185296_A;
    }

    @Override
    public boolean isSpecialSupported(ItemStack item, Enchantment ench) {
        return ench == Enchantments.field_185307_s;
    }

    public LocaleComp getLangComponent() {
        return this.name;
    }

    public LocaleComp getLangComponent(ItemStack stack) {
        return this.getLangComponent();
    }

    public Item setUnlocalizedName(LocaleComp component) {
        this.name = component;
        return super.func_77655_b(component.getUnlocalized());
    }

    public Item func_77655_b(String unlocalizedName) {
        this.name = new LangComponentHolder.LocaleItemComp("item." + unlocalizedName);
        return super.func_77655_b(unlocalizedName);
    }

    public String func_77658_a() {
        return this.getLangComponent().getUnlocalized();
    }

    public String func_77667_c(ItemStack stack) {
        return this.getLangComponent(stack).getUnlocalized();
    }

    public String func_77657_g(ItemStack stack) {
        return this.getLangComponent(stack).getLocalized();
    }

    public String func_77653_i(ItemStack stack) {
        return this.getLangComponent(stack).getLocalized();
    }

    @Override
    public boolean hasCustomTransform(int meta) {
        return true;
    }

    @Override
    public ResourceLocation getCustomTransform(int meta) {
        return new ResourceLocation("minecraft:models/item/handheld");
    }
}

