/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool.electric.scanners;

import ic2.api.classic.recipe.ClassicRecipes;
import ic2.core.item.tool.electric.scanners.IScanner;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.util.obj.ToolTipType;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class BaseScanner
implements IScanner {
    int radius;
    int cost;
    int tier;
    boolean ore;
    LocaleComp name;

    public BaseScanner(int rad, int eu, boolean isOre, int euTier, LocaleComp lang) {
        this.radius = rad;
        this.cost = eu;
        this.ore = isOre;
        this.tier = euTier;
        this.name = lang;
    }

    @Override
    public int getOreValue(ItemStack stack, IBlockState state) {
        int result = ClassicRecipes.oreRegistry.getOreValue(state);
        if (this.ore) {
            return Math.max(0, result);
        }
        return result > 0 ? 1 : 0;
    }

    @Override
    public boolean isAdv(ItemStack stack) {
        return false;
    }

    @Override
    public int getOreValue(ItemStack stack, IBlockState state, World world, BlockPos pos) {
        return this.getOreValue(stack, state);
    }

    @Override
    public int getRadius(ItemStack stack) {
        return this.radius;
    }

    @Override
    public int getCost(ItemStack stack) {
        return this.cost;
    }

    @Override
    public boolean isValue(ItemStack stack) {
        return this.ore;
    }

    @Override
    public int getTier(ItemStack stack) {
        return this.tier;
    }

    @Override
    public boolean isFluidScanner(ItemStack stack) {
        return false;
    }

    @Override
    public LocaleComp getName(ItemStack stack) {
        return this.name;
    }

    @Override
    public boolean hasCustomInfo(ItemStack stack) {
        return false;
    }

    @Override
    public boolean addCustomInfo(ItemStack stack, EntityPlayer player, List<String> list, List<String> post, Map<ToolTipType, List<String>> sortedTooltip) {
        return false;
    }

    @Override
    public boolean isFluidValid(ItemStack stack, FluidStack fluid) {
        return false;
    }

    @Override
    public boolean showTargets(ItemStack stack) {
        return false;
    }

    @Override
    public Set<IBlockState> getTargets(ItemStack stack) {
        return EMPTY_STATES;
    }

    @Override
    public Set<Fluid> getFluidTargets(ItemStack stack) {
        return EMPTY_FLUIDS;
    }

    @Override
    public boolean hasRightClick(ItemStack stack) {
        return false;
    }

    @Override
    public boolean onRightClick(ItemStack stack, EntityPlayer player, EnumHand hand, World world) {
        return false;
    }

    @Override
    public boolean hasAOE(ItemStack stack) {
        return true;
    }
}

