/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.network.buffers;

import ic2.api.classic.network.INetworkFieldData;
import ic2.api.classic.network.adv.IBitLevelOverride;
import ic2.api.classic.network.adv.IInputBuffer;
import ic2.api.classic.network.adv.NetworkField;
import ic2.core.network.buffers.InputBuffer;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;

public class FieldBuffer {
    final Class<? extends TileEntity> tile;
    Map<String, FieldInfo> fieldNameToIndex = new HashMap<String, FieldInfo>();
    Map<Integer, FieldInfo> indexToField = new HashMap<Integer, FieldInfo>();

    public FieldBuffer(Class<? extends TileEntity> clz) {
        this.tile = clz;
    }

    public void initClass(TileEntity tileData) {
        try {
            IBitLevelOverride override = tileData instanceof IBitLevelOverride ? (IBitLevelOverride)tileData : null;
            for (Class<? extends TileEntity> currentClass = this.tile; currentClass != null && currentClass != TileEntity.class; currentClass = currentClass.getSuperclass()) {
                Field[] fields = currentClass.getDeclaredFields();
                for (int i = 0; i < fields.length; ++i) {
                    Field field = fields[i];
                    NetworkField data = field.getDeclaredAnnotation(NetworkField.class);
                    String name = field.getName();
                    if (data != null) {
                        FieldInfo info = new FieldInfo(field, name, data, override);
                        this.fieldNameToIndex.put(name, info);
                        this.indexToField.put(info.getIndex(), info);
                        field.setAccessible(true);
                        continue;
                    }
                    this.fieldNameToIndex.put(name, new FieldInfo(field, name));
                    field.setAccessible(true);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public FieldInfo getInfo(String id) {
        return this.fieldNameToIndex.get(id);
    }

    public FieldInfo getInfo(int index) {
        return this.indexToField.get(index);
    }

    public static class FieldInfo {
        Field field;
        boolean isNew;
        int index;
        String fieldName;
        NetworkField.BitLevel compression;

        public FieldInfo(Field theField, String fieldID) {
            this.field = theField;
            this.fieldName = fieldID;
            this.index = -1;
            this.isNew = false;
            this.compression = NetworkField.BitLevel.Bit0;
        }

        public FieldInfo(Field theField, String fieldID, NetworkField fieldData, IBitLevelOverride override) {
            this.field = theField;
            this.fieldName = fieldID;
            this.index = fieldData.index();
            this.isNew = this.index != -1;
            this.compression = fieldData.compression();
            if (override.hasOverride(this.index, this.fieldName)) {
                this.compression = override.getOverride(this.index, this.fieldName);
            }
        }

        public int getIndex() {
            return this.index;
        }

        public boolean isNew() {
            return this.isNew;
        }

        public NetworkField.BitLevel getBits() {
            return this.compression;
        }

        public String getFieldID() {
            return this.fieldName;
        }

        public Object getData(TileEntity tile) {
            try {
                return this.field.get(tile);
            }
            catch (Exception e) {
                return null;
            }
        }

        public void setData(TileEntity tile, Object obj) throws Exception {
            if (this.field.getType().isEnum()) {
                obj = Enum.valueOf(this.field.getType(), (String)obj);
            }
            if (INetworkFieldData.class.isAssignableFrom(this.field.getType()) && obj instanceof InputBuffer) {
                INetworkFieldData data = (INetworkFieldData)this.field.get(tile);
                data.read((IInputBuffer)obj);
            } else {
                this.field.set(tile, obj);
            }
        }
    }
}

