/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.network.packets.client;

import ic2.api.classic.network.INetworkClientTileEventListener;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.core.IC2;
import ic2.core.network.packets.IC2Packet;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileClientEventPacket
extends IC2Packet {
    int dimID;
    BlockPos pos;
    int eventID;
    int value;
    boolean withValue;
    UUID id;

    public TileClientEventPacket() {
    }

    public TileClientEventPacket(TileEntity par1, int par2, UUID player) {
        this.dimID = par1.func_145831_w().field_73011_w.getDimension();
        this.pos = par1.func_174877_v();
        this.eventID = par2;
        this.withValue = false;
        this.id = player;
    }

    public TileClientEventPacket(TileEntity par1, int par2, int par3, UUID player) {
        this.dimID = par1.func_145831_w().field_73011_w.getDimension();
        this.pos = par1.func_174877_v();
        this.eventID = par2;
        this.value = par3;
        this.withValue = true;
        this.id = player;
    }

    @Override
    public void read(ByteBuf par1) {
        this.dimID = par1.readInt();
        this.pos = BlockPos.func_177969_a((long)par1.readLong());
        this.eventID = par1.readInt();
        this.withValue = par1.readBoolean();
        if (this.withValue) {
            this.value = par1.readInt();
        }
        long most = par1.readLong();
        long least = par1.readLong();
        this.id = new UUID(most, least);
    }

    @Override
    public void write(ByteBuf par1) {
        par1.writeInt(this.dimID);
        par1.writeLong(this.pos.func_177986_g());
        par1.writeInt(this.eventID);
        par1.writeBoolean(this.withValue);
        if (this.withValue) {
            par1.writeInt(this.value);
        }
        par1.writeLong(this.id.getMostSignificantBits());
        par1.writeLong(this.id.getLeastSignificantBits());
    }

    @Override
    public void handlePacket(EntityPlayer par1) {
        World world = IC2.platform.getWorld(this.dimID);
        if (world == null) {
            throw new RuntimeException("Packet Has been sended wrong");
        }
        if (!par1.func_110124_au().equals(this.id)) {
            par1 = world.func_152378_a(this.id);
        }
        if (par1 == null) {
            return;
        }
        TileEntity tile = world.func_175625_s(this.pos);
        if (!this.withValue) {
            this.handeWithoutValue(tile, par1, this.eventID);
        } else {
            this.handeWithValue(tile, par1, this.eventID, this.value);
        }
    }

    private void handeWithoutValue(TileEntity tile, EntityPlayer player, int eventID) {
        if (!(tile instanceof INetworkClientTileEntityEventListener)) {
            throw new RuntimeException("Packet was sended with Incorrect Data");
        }
        ((INetworkClientTileEntityEventListener)tile).onNetworkEvent(player, eventID);
    }

    private void handeWithValue(TileEntity tile, EntityPlayer player, int eventID, int value) {
        if (!(tile instanceof INetworkClientTileEventListener)) {
            throw new RuntimeException("Packet was sended with Incorrect Data");
        }
        ((INetworkClientTileEventListener)tile).onNetworkEvent(player, eventID, value);
    }
}

