/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.platform.registry;

import com.google.common.base.Strings;
import ic2.api.classic.recipe.ClassicRecipes;
import ic2.api.classic.recipe.crafting.RecipeInputFluid;
import ic2.api.classic.recipe.machine.ICannerRegistry;
import ic2.api.classic.recipe.machine.IMachineFilter;
import ic2.api.classic.recipe.machine.IMachineRecipeList;
import ic2.api.recipe.IRecipeInput;
import ic2.core.item.recipe.entry.RecipeInputItemStack;
import ic2.core.item.recipe.entry.RecipeInputOreDict;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class IMCManager {
    static List<IMCExtractor> extractors = new ArrayList<IMCExtractor>();

    public static void init() {
        IMCManager.registerExtractor(new MachineExtractor("macerator", ClassicRecipes.macerator));
        IMCManager.registerExtractor(new MachineExtractor("extractor", ClassicRecipes.extractor));
        IMCManager.registerExtractor(new MachineExtractor("compressor", ClassicRecipes.compressor));
        IMCManager.registerExtractor(new MachineExtractor("furnace", ClassicRecipes.furnace));
        IMCManager.registerExtractor(new MachineExtractor("recycler", ClassicRecipes.recycler));
        IMCManager.registerExtractor(new MachineExtractor("massfab", ClassicRecipes.massfabAmplifier).allowNullOutput());
        IMCManager.registerExtractor(new RecyclerFilter());
        IMCManager.registerExtractor(new CanningExtractor());
        IMCManager.registerExtractor(new ElectrolyzerExtractor());
        IMCManager.registerExtractor(new ScrapBoxExtractor());
        IMCManager.registerExtractor(new ScannerExtractor());
    }

    public static void registerExtractor(IMCExtractor extractor) {
        if (extractor == null) {
            return;
        }
        extractors.add(extractor);
    }

    public static void processMessages(List<FMLInterModComms.IMCMessage> messages) {
        for (FMLInterModComms.IMCMessage message : messages) {
            for (int i = 0; i < extractors.size(); ++i) {
                IMCExtractor extractor = extractors.get(i);
                if (!extractor.canProcess(message.key)) continue;
                extractor.process(message);
            }
        }
    }

    public static class ScannerExtractor
    implements IMCExtractor {
        @Override
        public boolean canProcess(String id) {
            return "oreScanner".equals(id);
        }

        @Override
        public void process(FMLInterModComms.IMCMessage message) {
            if (message.isStringMessage()) {
                IBlockState state;
                Block block;
                String text = message.getStringValue();
                String[] array = text.split(":");
                if (array.length == 2) {
                    Block block2 = Block.func_149684_b((String)array[0]);
                    if (block2 != null) {
                        ClassicRecipes.oreRegistry.registerValueableOre(block2, Integer.parseInt(array[1]));
                    }
                } else if (array.length == 3 && (block = Block.func_149684_b((String)array[0])) != null && (state = block.func_176203_a(Integer.parseInt(array[1]))) != null) {
                    ClassicRecipes.oreRegistry.registerValueableOre(state, Integer.parseInt(array[2]));
                }
            }
        }
    }

    public static class ScrapBoxExtractor
    implements IMCExtractor {
        @Override
        public boolean canProcess(String id) {
            return "scrapBox".equals(id);
        }

        @Override
        public void process(FMLInterModComms.IMCMessage message) {
            if (!message.isNBTMessage()) {
                return;
            }
            NBTTagCompound nbt = message.getNBTValue();
            ItemStack stack = new ItemStack(nbt.func_74775_l("Input"));
            if (stack.func_190926_b()) {
                return;
            }
            ClassicRecipes.scrapboxDrops.addDrop(stack, nbt.func_74760_g("Chance"));
        }
    }

    public static class ElectrolyzerExtractor
    implements IMCExtractor {
        @Override
        public boolean canProcess(String id) {
            return "electrolyzer".equals(id);
        }

        @Override
        public void process(FMLInterModComms.IMCMessage message) {
            if (!message.isNBTMessage()) {
                return;
            }
            NBTTagCompound nbt = message.getNBTValue();
            String id = nbt.func_74779_i("id");
            if (Strings.isNullOrEmpty((String)id)) {
                return;
            }
            ItemStack input = new ItemStack(nbt.func_74775_l("Input"));
            if (input.func_190926_b()) {
                return;
            }
            ItemStack output = new ItemStack(nbt.func_74775_l("Output"));
            if (output.func_190926_b()) {
                return;
            }
            int energy = nbt.func_74762_e("Energy");
            int mode = nbt.func_74762_e("Mode");
            switch (mode) {
                case 0: {
                    ClassicRecipes.electrolyzer.addBothRecipe(input, output, energy, id);
                    break;
                }
                case 1: {
                    ClassicRecipes.electrolyzer.addChargeRecipe(input, output, energy, id);
                    break;
                }
                case 2: {
                    ClassicRecipes.electrolyzer.addDischargeRecipe(input, output, energy, id);
                }
            }
        }
    }

    public static class CanningExtractor
    implements IMCExtractor {
        @Override
        public boolean canProcess(String id) {
            return "canner".equals(id);
        }

        @Override
        public void process(FMLInterModComms.IMCMessage message) {
            if (!message.isNBTMessage()) {
                return;
            }
            ICannerRegistry registry = ClassicRecipes.canningMachine;
            NBTTagCompound nbt = message.getNBTValue();
            String task = nbt.func_74779_i("Task");
            if (task.equals("CanEffect")) {
                int id = nbt.func_74762_e("effectID");
                NBTTagList list = nbt.func_150295_c("ItemList", 10);
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    ItemStack stack = new ItemStack(list.func_150305_b(i));
                    if (stack.func_190926_b()) continue;
                    items.add(stack);
                }
                registry.registerItemsForEffect(id, items.toArray(new ItemStack[items.size()]));
            } else if (task.equals("fuel")) {
                ItemStack stack = new ItemStack(nbt.func_74775_l("Input"));
                if (stack.func_190926_b()) {
                    return;
                }
                if (nbt.func_74764_b("fuelValue")) {
                    registry.registerFuelValue(stack, nbt.func_74762_e("fuelValue"));
                }
                if (nbt.func_74764_b("fuelMultiplier")) {
                    registry.registerFuelMultiplier(stack, nbt.func_74760_g("fuelMultiplier"));
                }
            }
        }
    }

    public static class RecyclerFilter
    implements IMCExtractor {
        @Override
        public boolean canProcess(String id) {
            return "recycler-Filter".equals(id);
        }

        @Override
        public void process(FMLInterModComms.IMCMessage message) {
            IMachineFilter filter = ClassicRecipes.recycler.getFilter();
            try {
                if (message.isItemStackMessage()) {
                    filter.addItem(message.getItemStackValue());
                } else if (message.isStringMessage()) {
                    filter.addFilter(new RecipeInputOreDict(message.getStringValue()));
                } else if (message.isNBTMessage()) {
                    filter.addFilter(new RecipeInputFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)message.getNBTValue())));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static class MachineExtractor
    implements IMCExtractor {
        String tracker;
        IMachineRecipeList list;
        boolean allowNull = false;

        public MachineExtractor(String id, IMachineRecipeList manager) {
            this.tracker = id;
            this.list = manager;
        }

        public MachineExtractor allowNullOutput() {
            this.allowNull = true;
            return this;
        }

        @Override
        public boolean canProcess(String id) {
            return this.tracker != null && this.tracker.equals(id);
        }

        @Override
        public void process(FMLInterModComms.IMCMessage message) {
            if (!message.isNBTMessage()) {
                return;
            }
            NBTTagCompound nbt = message.getNBTValue();
            String id = nbt.func_74779_i("id");
            if (Strings.isNullOrEmpty((String)id)) {
                return;
            }
            int inputType = nbt.func_74762_e("InputType");
            IRecipeInput input = this.getInput(inputType, nbt.func_74775_l("Input"));
            if (input == null) {
                return;
            }
            ItemStack output = new ItemStack(nbt.func_74775_l("Output"));
            if (output.func_190926_b() && !this.allowNull) {
                return;
            }
            this.list.addRecipe(input, nbt.func_74764_b("Flags") ? nbt.func_74775_l("Flags") : null, output, nbt.func_74760_g("Exp"), id);
        }

        private IRecipeInput getInput(int type, NBTTagCompound nbt) {
            try {
                switch (type) {
                    case 0: {
                        return new RecipeInputItemStack(new ItemStack(nbt));
                    }
                    case 1: {
                        return new RecipeInputOreDict(nbt.func_74779_i("ID"), nbt.func_74762_e("StackSize"));
                    }
                    case 2: {
                        return new RecipeInputFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt), nbt.func_74762_e("StackSize"));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    public static interface IMCExtractor {
        public boolean canProcess(String var1);

        public void process(FMLInterModComms.IMCMessage var1);
    }
}

