/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.platform.wind.worlds;

import ic2.api.classic.wind.IWindHandlerInfo;
import ic2.api.classic.wind.IWindStream;
import ic2.core.IC2;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class WindHandlerStandartOverworld
implements IWindHandlerInfo {
    Random rand = new Random();
    double speed;
    double nextSpeed;
    int time;
    List<IWindStream> stream = new ArrayList<IWindStream>();

    public WindHandlerStandartOverworld() {
        this.stream.add(new WindStream());
        this.time = this.rand.nextInt(IC2.config.getInt("maxWindChangeDelay"));
        this.speed = this.nextSpeed = 20.0 * ((double)this.rand.nextInt(150) / 100.0);
    }

    @Override
    public void onTick() {
        if (this.time-- <= 0) {
            this.time = this.rand.nextInt(IC2.config.getInt("maxWindChangeDelay"));
            this.nextSpeed = 20.0 * ((double)this.rand.nextInt(150) / 100.0);
        }
        if (this.speed > this.nextSpeed) {
            this.speed -= 0.1;
        } else if (this.speed < this.nextSpeed) {
            this.speed += 0.1;
        }
    }

    @Override
    public double getWindStrenght(BlockPos pos, float rotation, float angle) {
        return this.speed;
    }

    @Override
    public double getMaxWind() {
        return 20.0;
    }

    @Override
    public List<IWindStream> getStreams() {
        return this.stream;
    }

    @Override
    public void onUnloaded() {
        this.stream.clear();
    }

    public class WindStream
    implements IWindStream {
        @Override
        public boolean isAxisSupported(EnumFacing.Axis axis) {
            return false;
        }

        @Override
        public AxisAlignedBB getBoundingBox() {
            return new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }

        @Override
        public boolean hasDirection() {
            return false;
        }

        @Override
        public float getDirection() {
            return 0.0f;
        }

        @Override
        public boolean hasAngle() {
            return false;
        }

        @Override
        public float getAngle() {
            return 0.0f;
        }

        @Override
        public double getWindSpeed() {
            return WindHandlerStandartOverworld.this.speed;
        }
    }
}

