/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.api.implementation;

import java.util.Objects;
import java.util.SortedSet;
import java.util.UUID;
import me.lucko.luckperms.common.actionlog.Log;
import me.lucko.luckperms.common.api.ApiUtils;
import net.luckperms.api.actionlog.Action;
import net.luckperms.api.actionlog.ActionLog;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ApiActionLog
implements ActionLog {
    private final Log handle;

    public ApiActionLog(Log handle) {
        this.handle = handle;
    }

    @Override
    public @NonNull SortedSet<Action> getContent() {
        return this.handle.getContent();
    }

    @Override
    public @NonNull SortedSet<Action> getContent(@NonNull UUID actor) {
        Objects.requireNonNull(actor, "actor");
        return this.handle.getContent(actor);
    }

    @Override
    public @NonNull SortedSet<Action> getUserHistory(@NonNull UUID uniqueId) {
        Objects.requireNonNull(uniqueId, "uuid");
        return this.handle.getUserHistory(uniqueId);
    }

    @Override
    public @NonNull SortedSet<Action> getGroupHistory(@NonNull String name) {
        Objects.requireNonNull(name, "name");
        return this.handle.getGroupHistory(ApiUtils.checkName(name));
    }

    @Override
    public @NonNull SortedSet<Action> getTrackHistory(@NonNull String name) {
        Objects.requireNonNull(name, "name");
        return this.handle.getTrackHistory(ApiUtils.checkName(name));
    }
}

