/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.cache;

import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import me.lucko.luckperms.common.cache.LoadingMap;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class PatternCache {
    private static final Map<String, CachedPattern> CACHE = LoadingMap.of(s -> {
        try {
            return new CachedPattern(Pattern.compile(s));
        }
        catch (PatternSyntaxException e) {
            return new CachedPattern(e);
        }
    });

    private PatternCache() {
    }

    public static CachedPattern lookup(String regex) {
        CachedPattern pattern = CACHE.get(regex);
        Objects.requireNonNull(pattern, "pattern");
        return pattern;
    }

    public static Pattern compile(String regex) throws PatternSyntaxException {
        CachedPattern pattern = PatternCache.lookup(regex);
        if (pattern.ex != null) {
            throw pattern.ex;
        }
        return pattern.instance;
    }

    public static final class CachedPattern {
        private final Pattern instance;
        private final PatternSyntaxException ex;

        CachedPattern(Pattern instance) {
            this.instance = instance;
            this.ex = null;
        }

        CachedPattern(PatternSyntaxException ex) {
            this.instance = null;
            this.ex = ex;
        }

        public @Nullable Pattern getPattern() {
            return this.instance;
        }

        public @Nullable PatternSyntaxException getException() {
            return this.ex;
        }
    }
}

