/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.cacheddata.type;

import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import me.lucko.luckperms.common.cacheddata.UsageTracked;
import me.lucko.luckperms.common.cacheddata.type.MetaAccumulator;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.verbose.event.MetaCheckEvent;
import net.luckperms.api.cacheddata.CachedMetaData;
import net.luckperms.api.metastacking.MetaStackDefinition;
import net.luckperms.api.query.QueryOptions;
import net.luckperms.api.query.meta.MetaValueSelector;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SimpleMetaCache
extends UsageTracked
implements CachedMetaData {
    private final LuckPermsPlugin plugin;
    private final QueryOptions queryOptions;
    protected final Map<String, List<String>> meta;
    protected final Map<String, String> flattenedMeta;
    protected final SortedMap<Integer, String> prefixes;
    protected final SortedMap<Integer, String> suffixes;
    protected final int weight;
    protected final String primaryGroup;
    private final MetaStackDefinition prefixDefinition;
    private final MetaStackDefinition suffixDefinition;
    private final String prefix;
    private final String suffix;

    public SimpleMetaCache(LuckPermsPlugin plugin, QueryOptions queryOptions, MetaAccumulator sourceMeta) {
        this.plugin = plugin;
        this.queryOptions = queryOptions;
        Map meta = Multimaps.asMap((ListMultimap)ImmutableListMultimap.copyOf(sourceMeta.getMeta()));
        MetaValueSelector metaValueSelector = this.queryOptions.option(MetaValueSelector.KEY).orElseGet(() -> this.plugin.getConfiguration().get(ConfigKeys.META_VALUE_SELECTOR));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry e : meta.entrySet()) {
            if (((List)e.getValue()).isEmpty()) continue;
            String selected = metaValueSelector.selectValue((String)e.getKey(), (List)e.getValue());
            if (selected == null) {
                throw new NullPointerException(metaValueSelector + " returned null");
            }
            builder.put((Object)((String)e.getKey()), (Object)selected);
        }
        this.flattenedMeta = builder.build();
        this.meta = new LowerCaseMetaMap(meta);
        this.prefixes = ImmutableSortedMap.copyOfSorted(sourceMeta.getPrefixes());
        this.suffixes = ImmutableSortedMap.copyOfSorted(sourceMeta.getSuffixes());
        this.weight = sourceMeta.getWeight();
        this.primaryGroup = sourceMeta.getPrimaryGroup();
        this.prefixDefinition = sourceMeta.getPrefixDefinition();
        this.suffixDefinition = sourceMeta.getSuffixDefinition();
        this.prefix = sourceMeta.getPrefix();
        this.suffix = sourceMeta.getSuffix();
    }

    public String getMetaValue(String key, MetaCheckEvent.Origin origin) {
        Objects.requireNonNull(key, "key");
        return this.flattenedMeta.get(key.toLowerCase());
    }

    @Override
    public final String getMetaValue(@NonNull String key) {
        return this.getMetaValue(key, MetaCheckEvent.Origin.LUCKPERMS_API);
    }

    public String getPrefix(MetaCheckEvent.Origin origin) {
        return this.prefix;
    }

    @Override
    public final String getPrefix() {
        return this.getPrefix(MetaCheckEvent.Origin.LUCKPERMS_API);
    }

    public String getSuffix(MetaCheckEvent.Origin origin) {
        return this.suffix;
    }

    @Override
    public final String getSuffix() {
        return this.getSuffix(MetaCheckEvent.Origin.LUCKPERMS_API);
    }

    public Map<String, List<String>> getMeta(MetaCheckEvent.Origin origin) {
        return this.meta;
    }

    @Override
    public final @NonNull Map<String, List<String>> getMeta() {
        return this.getMeta(MetaCheckEvent.Origin.LUCKPERMS_API);
    }

    @Override
    public @NonNull SortedMap<Integer, String> getPrefixes() {
        return this.prefixes;
    }

    @Override
    public @NonNull SortedMap<Integer, String> getSuffixes() {
        return this.suffixes;
    }

    public int getWeight(MetaCheckEvent.Origin origin) {
        return this.weight;
    }

    public final int getWeight() {
        return this.getWeight(MetaCheckEvent.Origin.LUCKPERMS_API);
    }

    public @Nullable String getPrimaryGroup(MetaCheckEvent.Origin origin) {
        return this.primaryGroup;
    }

    @Override
    public final @Nullable String getPrimaryGroup() {
        return this.getPrimaryGroup(MetaCheckEvent.Origin.LUCKPERMS_API);
    }

    @Override
    public @NonNull MetaStackDefinition getPrefixStackDefinition() {
        return this.prefixDefinition;
    }

    @Override
    public @NonNull MetaStackDefinition getSuffixStackDefinition() {
        return this.suffixDefinition;
    }

    @Override
    public @NonNull QueryOptions getQueryOptions() {
        return this.queryOptions;
    }

    private static final class LowerCaseMetaMap
    extends ForwardingMap<String, List<String>> {
        private final Map<String, List<String>> delegate;

        private LowerCaseMetaMap(Map<String, List<String>> delegate) {
            this.delegate = delegate;
        }

        protected Map<String, List<String>> delegate() {
            return this.delegate;
        }

        public List<String> get(Object k) {
            if (k == null) {
                return null;
            }
            String key = (String)k;
            return (List)super.get((Object)key.toLowerCase());
        }
    }
}

