/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.calculator;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import me.lucko.luckperms.common.cache.LoadingMap;
import me.lucko.luckperms.common.cacheddata.CacheMetadata;
import me.lucko.luckperms.common.calculator.processor.PermissionProcessor;
import me.lucko.luckperms.common.calculator.result.TristateResult;
import me.lucko.luckperms.common.model.HolderType;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.verbose.event.PermissionCheckEvent;
import org.checkerframework.checker.nullness.qual.NonNull;

public class PermissionCalculator
implements Function<String, TristateResult> {
    private final LuckPermsPlugin plugin;
    private final CacheMetadata metadata;
    private final PermissionProcessor[] processors;
    private final LoadingMap<String, TristateResult> lookupCache = LoadingMap.of(this);
    private final String verboseCheckTarget;

    public PermissionCalculator(LuckPermsPlugin plugin, CacheMetadata metadata, Collection<PermissionProcessor> processors) {
        this.plugin = plugin;
        this.metadata = metadata;
        this.processors = processors.toArray(new PermissionProcessor[0]);
        this.verboseCheckTarget = this.metadata.getHolderType() == HolderType.GROUP ? "group/" + this.metadata.getObjectName() : this.metadata.getObjectName();
    }

    public TristateResult checkPermission(String permission, PermissionCheckEvent.Origin origin) {
        TristateResult result = this.lookupCache.get(permission);
        this.plugin.getVerboseHandler().offerPermissionCheckEvent(origin, this.verboseCheckTarget, this.metadata.getQueryOptions(), permission, result);
        return result;
    }

    @Override
    public TristateResult apply(@NonNull String permission) {
        permission = permission.toLowerCase();
        this.plugin.getPermissionRegistry().offer(permission);
        TristateResult result = TristateResult.UNDEFINED;
        for (PermissionProcessor processor : this.processors) {
            result = processor.hasPermission(result, permission);
        }
        return result;
    }

    public synchronized void setSourcePermissions(Map<String, Boolean> sourceMap) {
        for (PermissionProcessor processor : this.processors) {
            processor.setSource(sourceMap);
            processor.refresh();
        }
    }

    public void invalidateCache() {
        for (PermissionProcessor processor : this.processors) {
            processor.invalidate();
        }
        this.lookupCache.clear();
    }
}

