/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.command.utils;

import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.Command;
import me.lucko.luckperms.common.command.abstraction.CommandException;
import me.lucko.luckperms.common.command.abstraction.GenericChildCommand;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.sender.Sender;

public abstract class ArgumentException
extends CommandException {

    public static class InvalidPriority
    extends ArgumentException {
        private final String invalidPriority;

        public InvalidPriority(String invalidPriority) {
            this.invalidPriority = invalidPriority;
        }

        @Override
        public CommandResult handle(Sender sender) {
            Message.META_INVALID_PRIORITY.send(sender, this.invalidPriority);
            return CommandResult.INVALID_ARGS;
        }
    }

    public static class InvalidDate
    extends ArgumentException {
        private final String invalidDate;

        public InvalidDate(String invalidDate) {
            this.invalidDate = invalidDate;
        }

        @Override
        protected CommandResult handle(Sender sender) {
            Message.ILLEGAL_DATE_ERROR.send(sender, this.invalidDate);
            return CommandResult.INVALID_ARGS;
        }
    }

    public static class PastDate
    extends ArgumentException {
        @Override
        protected CommandResult handle(Sender sender) {
            Message.PAST_DATE_ERROR.send(sender);
            return CommandResult.INVALID_ARGS;
        }
    }

    public static class DetailedUsage
    extends ArgumentException {
        @Override
        protected CommandResult handle(Sender sender) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CommandResult handle(Sender sender, String label, Command<?> command) {
            command.sendDetailedUsage(sender, label);
            return CommandResult.INVALID_ARGS;
        }

        @Override
        public CommandResult handle(Sender sender, GenericChildCommand command) {
            command.sendDetailedUsage(sender);
            return CommandResult.INVALID_ARGS;
        }
    }
}

