/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.generic.parent;

import java.time.Duration;
import java.util.List;
import me.lucko.luckperms.common.actionlog.LoggedAction;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.CommandException;
import me.lucko.luckperms.common.command.abstraction.GenericChildCommand;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.tabcomplete.TabCompleter;
import me.lucko.luckperms.common.command.tabcomplete.TabCompletions;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.command.utils.StorageAssistant;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.node.types.Inheritance;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.storage.misc.DataConstraints;
import me.lucko.luckperms.common.util.Predicates;
import me.lucko.luckperms.lib.adventure.text.Component;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.MutableContextSet;
import net.luckperms.api.model.data.DataMutateResult;
import net.luckperms.api.model.data.DataType;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.types.InheritanceNode;

public class ParentRemoveTemp
extends GenericChildCommand {
    public ParentRemoveTemp() {
        super(CommandSpec.PARENT_REMOVE_TEMP, "removetemp", CommandPermission.USER_PARENT_REMOVE_TEMP, CommandPermission.GROUP_PARENT_REMOVE_TEMP, Predicates.is(0));
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, PermissionHolder target, ArgumentList args, String label, CommandPermission permission) throws CommandException {
        if (ArgumentPermissions.checkModifyPerms(plugin, sender, permission, target)) {
            Message.COMMAND_NO_PERMISSION.send(sender);
            return CommandResult.NO_PERMISSION;
        }
        String groupName = args.getLowercase(0, DataConstraints.GROUP_NAME_TEST_ALLOW_SPACE);
        Duration duration = args.getDurationOrDefault(1, null);
        int fromIndex = duration == null ? 1 : 2;
        MutableContextSet context = args.getContextOrDefault(fromIndex, plugin);
        if (ArgumentPermissions.checkContext(plugin, sender, permission, context) || ArgumentPermissions.checkGroup(plugin, sender, target, (ContextSet)context) || ArgumentPermissions.checkGroup(plugin, sender, groupName, (ContextSet)context) || ArgumentPermissions.checkArguments(plugin, sender, permission, groupName)) {
            Message.COMMAND_NO_PERMISSION.send(sender);
            return CommandResult.NO_PERMISSION;
        }
        DataMutateResult.WithMergedNode result = target.unsetNode(DataType.NORMAL, (Node)((InheritanceNode.Builder)((InheritanceNode.Builder)Inheritance.builder(groupName).expiry(10L)).withContext(context)).build(), duration);
        if (result.getResult().wasSuccessful()) {
            Node mergedNode = result.getMergedNode();
            if (mergedNode != null) {
                Message.UNSET_TEMP_INHERIT_SUBTRACT_SUCCESS.send(sender, target, (Component)Component.text((String)groupName), mergedNode.getExpiryDuration(), context, duration);
                LoggedAction.build().source(sender).target(target).description("parent", "removetemp", groupName, duration, context).build().submit(plugin, sender);
            } else {
                Message.UNSET_TEMP_INHERIT_SUCCESS.send(sender, target, (Component)Component.text((String)groupName), context);
                LoggedAction.build().source(sender).target(target).description("parent", "removetemp", groupName, context).build().submit(plugin, sender);
            }
            StorageAssistant.save(target, sender, plugin);
            return CommandResult.SUCCESS;
        }
        Message.DOES_NOT_TEMP_INHERIT.send(sender, target, (Component)Component.text((String)groupName), context);
        return CommandResult.STATE_ERROR;
    }

    @Override
    public List<String> tabComplete(LuckPermsPlugin plugin, Sender sender, ArgumentList args) {
        return TabCompleter.create().at(0, TabCompletions.groups(plugin)).from(1, TabCompletions.contexts(plugin)).complete((List<String>)((Object)args));
    }
}

