/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.track;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import me.lucko.luckperms.common.command.abstraction.ParentCommand;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.utils.StorageAssistant;
import me.lucko.luckperms.common.commands.track.TrackAppend;
import me.lucko.luckperms.common.commands.track.TrackClear;
import me.lucko.luckperms.common.commands.track.TrackClone;
import me.lucko.luckperms.common.commands.track.TrackEditor;
import me.lucko.luckperms.common.commands.track.TrackInfo;
import me.lucko.luckperms.common.commands.track.TrackInsert;
import me.lucko.luckperms.common.commands.track.TrackRemove;
import me.lucko.luckperms.common.commands.track.TrackRename;
import me.lucko.luckperms.common.model.Track;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.CaffeineFactory;
import me.lucko.luckperms.lib.caffeine.cache.LoadingCache;

public class TrackParentCommand
extends ParentCommand<Track, String> {
    private final LoadingCache<String, ReentrantLock> locks = CaffeineFactory.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build(key -> new ReentrantLock());

    public TrackParentCommand() {
        super(CommandSpec.TRACK, "Track", ParentCommand.Type.TAKES_ARGUMENT_FOR_TARGET, ImmutableList.builder().add((Object)new TrackInfo()).add((Object)new TrackEditor()).add((Object)new TrackAppend()).add((Object)new TrackInsert()).add((Object)new TrackRemove()).add((Object)new TrackClear()).add((Object)new TrackRename()).add((Object)new TrackClone()).build());
    }

    @Override
    protected String parseTarget(String target, LuckPermsPlugin plugin, Sender sender) {
        return target.toLowerCase();
    }

    @Override
    protected Track getTarget(String target, LuckPermsPlugin plugin, Sender sender) {
        return StorageAssistant.loadTrack(target, sender, plugin);
    }

    @Override
    protected ReentrantLock getLockForTarget(String target) {
        return (ReentrantLock)this.locks.get((Object)target);
    }

    @Override
    protected void cleanup(Track track, LuckPermsPlugin plugin) {
    }

    @Override
    protected List<String> getTargets(LuckPermsPlugin plugin) {
        return new ArrayList<String>(plugin.getTrackManager().getAll().keySet());
    }
}

