/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.event;

import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import me.lucko.luckperms.common.api.LuckPermsApiProvider;
import me.lucko.luckperms.common.event.LuckPermsEventListener;
import me.lucko.luckperms.common.event.LuckPermsEventSubscription;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.lib.eventbus.EventSubscriber;
import me.lucko.luckperms.lib.eventbus.SimpleEventBus;
import net.luckperms.api.event.EventBus;
import net.luckperms.api.event.EventSubscription;
import net.luckperms.api.event.LuckPermsEvent;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class AbstractEventBus<P>
implements EventBus,
AutoCloseable {
    private final LuckPermsPlugin plugin;
    private final LuckPermsApiProvider apiProvider;
    private final Bus bus = new Bus();

    protected AbstractEventBus(LuckPermsPlugin plugin, LuckPermsApiProvider apiProvider) {
        this.plugin = plugin;
        this.apiProvider = apiProvider;
    }

    public LuckPermsPlugin getPlugin() {
        return this.plugin;
    }

    public LuckPermsApiProvider getApiProvider() {
        return this.apiProvider;
    }

    protected abstract P checkPlugin(Object var1) throws IllegalArgumentException;

    public void post(LuckPermsEvent event) {
        this.bus.post(event);
    }

    public boolean shouldPost(Class<? extends LuckPermsEvent> eventClass) {
        return this.bus.hasSubscribers(eventClass);
    }

    public void subscribe(LuckPermsEventListener listener) {
        listener.bind(this);
    }

    @Override
    public <T extends LuckPermsEvent> @NonNull EventSubscription<T> subscribe(@NonNull Class<T> eventClass, @NonNull Consumer<? super T> handler) {
        Objects.requireNonNull(eventClass, "eventClass");
        Objects.requireNonNull(handler, "handler");
        return this.registerSubscription(eventClass, handler, null);
    }

    @Override
    public <T extends LuckPermsEvent> @NonNull EventSubscription<T> subscribe(Object plugin, @NonNull Class<T> eventClass, @NonNull Consumer<? super T> handler) {
        Objects.requireNonNull(plugin, "plugin");
        Objects.requireNonNull(eventClass, "eventClass");
        Objects.requireNonNull(handler, "handler");
        return this.registerSubscription(eventClass, handler, this.checkPlugin(plugin));
    }

    private <T extends LuckPermsEvent> EventSubscription<T> registerSubscription(Class<T> eventClass, Consumer<? super T> handler, Object plugin) {
        if (!eventClass.isInterface()) {
            throw new IllegalArgumentException("class " + eventClass + " is not an interface");
        }
        if (!LuckPermsEvent.class.isAssignableFrom(eventClass)) {
            throw new IllegalArgumentException("class " + eventClass.getName() + " does not implement LuckPermsEvent");
        }
        LuckPermsEventSubscription<? super T> eventHandler = new LuckPermsEventSubscription<T>(this, eventClass, handler, plugin);
        this.bus.register(eventClass, eventHandler);
        return eventHandler;
    }

    @Override
    public <T extends LuckPermsEvent> @NonNull Set<EventSubscription<T>> getSubscriptions(@NonNull Class<T> eventClass) {
        return this.bus.getHandlers(eventClass);
    }

    public void unregisterHandler(LuckPermsEventSubscription<?> handler) {
        this.bus.unregister(handler);
    }

    protected void unregisterHandlers(P plugin) {
        this.bus.unregister(sub -> ((LuckPermsEventSubscription)sub).getPlugin() == plugin);
    }

    @Override
    public void close() {
        this.bus.unregisterAll();
    }

    private static final class Bus
    extends SimpleEventBus<LuckPermsEvent> {
        Bus() {
            super(LuckPermsEvent.class);
        }

        protected boolean shouldPost(@NonNull LuckPermsEvent event, @NonNull EventSubscriber<?> subscriber) {
            return true;
        }

        public <T extends LuckPermsEvent> Set<EventSubscription<T>> getHandlers(Class<T> eventClass) {
            return super.subscribers().values().stream().filter(s -> s instanceof EventSubscription && ((EventSubscription)s).getEventClass().isAssignableFrom(eventClass)).map(s -> (EventSubscription)s).collect(Collectors.toSet());
        }
    }
}

