/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.locale;

import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.lib.adventure.key.Key;
import me.lucko.luckperms.lib.adventure.text.Component;
import me.lucko.luckperms.lib.adventure.translation.GlobalTranslator;
import me.lucko.luckperms.lib.adventure.translation.TranslationRegistry;
import me.lucko.luckperms.lib.adventure.translation.Translator;
import me.lucko.luckperms.lib.adventure.util.UTF8ResourceBundleControl;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TranslationManager {
    public static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    private final LuckPermsPlugin plugin;
    private final Path translationsDirectory;
    private final Set<Locale> installed = ConcurrentHashMap.newKeySet();
    private TranslationRegistry registry;

    public TranslationManager(LuckPermsPlugin plugin) {
        this.plugin = plugin;
        this.translationsDirectory = this.plugin.getBootstrap().getConfigDirectory().resolve("translations");
    }

    public Path getTranslationsDirectory() {
        return this.translationsDirectory;
    }

    public Set<Locale> getInstalledLocales() {
        return Collections.unmodifiableSet(this.installed);
    }

    public void reload() {
        if (this.registry != null) {
            GlobalTranslator.get().removeSource((Translator)this.registry);
            this.installed.clear();
        }
        this.registry = TranslationRegistry.create((Key)Key.key((String)"luckperms", (String)"main"));
        this.registry.defaultLocale(DEFAULT_LOCALE);
        this.loadCustom();
        this.loadBase();
        GlobalTranslator.get().addSource((Translator)this.registry);
    }

    private void loadBase() {
        ResourceBundle bundle = ResourceBundle.getBundle("luckperms", DEFAULT_LOCALE, UTF8ResourceBundleControl.get());
        try {
            this.registry.registerAll(DEFAULT_LOCALE, bundle, false);
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warn("Error loading default locale file", e);
        }
    }

    public void loadCustom() {
        List<Path> translationFiles;
        try (Stream<Path> stream = Files.list(this.translationsDirectory);){
            translationFiles = stream.filter(path -> path.getFileName().toString().endsWith(".properties")).collect(Collectors.toList());
        }
        catch (IOException e) {
            translationFiles = Collections.emptyList();
        }
        HashMap<Locale, ResourceBundle> loaded = new HashMap<Locale, ResourceBundle>();
        for (Path translationFile : translationFiles) {
            try {
                Map.Entry<Locale, ResourceBundle> result = this.loadCustomTranslationFile(translationFile);
                if (result == null) continue;
                loaded.put(result.getKey(), result.getValue());
            }
            catch (Exception e) {
                this.plugin.getLogger().warn("Error loading locale file: " + translationFile.getFileName(), e);
            }
        }
        loaded.forEach((locale, bundle) -> {
            Locale localeWithoutCountry = new Locale(locale.getLanguage());
            if (!locale.equals(localeWithoutCountry) && !localeWithoutCountry.equals(DEFAULT_LOCALE) && this.installed.add(localeWithoutCountry)) {
                this.registry.registerAll(localeWithoutCountry, bundle, false);
            }
        });
    }

    private Map.Entry<Locale, ResourceBundle> loadCustomTranslationFile(Path translationFile) {
        PropertyResourceBundle bundle;
        String fileName = translationFile.getFileName().toString();
        String localeString = fileName.substring(0, fileName.length() - ".properties".length());
        Locale locale = TranslationManager.parseLocale(localeString);
        if (locale == null) {
            this.plugin.getLogger().warn("Unknown locale '" + localeString + "' - unable to register.");
            return null;
        }
        try (BufferedReader reader = Files.newBufferedReader(translationFile, StandardCharsets.UTF_8);){
            bundle = new PropertyResourceBundle(reader);
        }
        catch (IOException e) {
            this.plugin.getLogger().warn("Error loading locale file: " + localeString, e);
            return null;
        }
        this.registry.registerAll(locale, (ResourceBundle)bundle, false);
        this.installed.add(locale);
        return Maps.immutableEntry((Object)locale, (Object)bundle);
    }

    public static Component render(Component component) {
        return TranslationManager.render(component, Locale.getDefault());
    }

    public static Component render(Component component, @Nullable String locale) {
        return TranslationManager.render(component, TranslationManager.parseLocale(locale));
    }

    public static Component render(Component component, @Nullable Locale locale) {
        if (locale == null && (locale = Locale.getDefault()) == null) {
            locale = DEFAULT_LOCALE;
        }
        return GlobalTranslator.render((Component)component, (Locale)locale);
    }

    public static @Nullable Locale parseLocale(@Nullable String locale) {
        return locale == null ? null : Translator.parseLocale((String)locale);
    }

    public static String localeDisplayName(Locale locale) {
        if (locale.getLanguage().equals("zh")) {
            if (locale.getCountry().equals("CN")) {
                return "\u7b80\u4f53\u4e2d\u6587";
            }
            if (locale.getCountry().equals("TW")) {
                return "\u7e41\u9ad4\u4e2d\u6587";
            }
            return locale.getDisplayCountry(locale) + locale.getDisplayLanguage(locale);
        }
        if (locale.getLanguage().equals("en") && locale.getCountry().equals("PT")) {
            return "Pirate";
        }
        return locale.getDisplayLanguage(locale);
    }
}

