/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.node.comparator;

import java.util.Comparator;
import me.lucko.luckperms.common.context.ContextSetComparator;
import me.lucko.luckperms.common.node.comparator.NodeComparator;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.node.Node;

public class NodeWithContextComparator
implements Comparator<Node> {
    private static final Comparator<? super Node> INSTANCE = new NodeWithContextComparator(ContextSetComparator.normal(), NodeComparator.normal());
    private static final Comparator<? super Node> REVERSE = new NodeWithContextComparator(ContextSetComparator.reverse(), NodeComparator.reverse());
    private final Comparator<? super ImmutableContextSet> contextSetComparator;
    private final Comparator<? super Node> nodeComparator;

    public static Comparator<? super Node> normal() {
        return INSTANCE;
    }

    public static Comparator<? super Node> reverse() {
        return REVERSE;
    }

    NodeWithContextComparator(Comparator<? super ImmutableContextSet> contextSetComparator, Comparator<? super Node> nodeComparator) {
        this.contextSetComparator = contextSetComparator;
        this.nodeComparator = nodeComparator;
    }

    @Override
    public int compare(Node o1, Node o2) {
        if (o1.equals(o2)) {
            return 0;
        }
        int result = this.contextSetComparator.compare(o1.getContexts(), o2.getContexts());
        if (result != 0) {
            return result;
        }
        return this.nodeComparator.compare(o1, o2);
    }
}

