/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.node.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.time.Instant;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import me.lucko.luckperms.common.context.ContextSetJsonSerializer;
import me.lucko.luckperms.common.node.factory.NodeBuilders;
import net.luckperms.api.node.Node;

public class NodeJsonSerializer {
    private NodeJsonSerializer() {
    }

    public static JsonArray serializeNodes(Collection<Node> nodes) {
        JsonArray arr = new JsonArray();
        for (Node node : nodes) {
            JsonObject attributes = new JsonObject();
            attributes.addProperty("type", node.getType().name().toLowerCase());
            attributes.addProperty("key", node.getKey());
            attributes.addProperty("value", Boolean.valueOf(node.getValue()));
            Instant expiry = node.getExpiry();
            if (expiry != null) {
                attributes.addProperty("expiry", (Number)expiry.getEpochSecond());
            }
            if (!node.getContexts().isEmpty()) {
                attributes.add("context", (JsonElement)ContextSetJsonSerializer.serialize(node.getContexts()));
            }
            arr.add((JsonElement)attributes);
        }
        return arr;
    }

    public static Set<Node> deserializeNodes(JsonArray arr) {
        HashSet<Node> nodes = new HashSet<Node>();
        for (JsonElement ent : arr) {
            JsonObject attributes = ent.getAsJsonObject();
            String key = attributes.get("key").getAsString();
            boolean value = attributes.get("value").getAsBoolean();
            Object builder = NodeBuilders.determineMostApplicable(key).value(value);
            if (attributes.has("expiry")) {
                builder.expiry(attributes.get("expiry").getAsLong());
            }
            if (attributes.has("context")) {
                builder.context(ContextSetJsonSerializer.deserialize(attributes.get("context")));
            }
            nodes.add((Node)builder.build());
        }
        return nodes;
    }
}

